/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.ServerNamePair;
import java.net.IDN;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.IPAddress;

public class ClientDelegate
extends Delegate {
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final Logger LOGGER = LogManager.getLogger();
    @Parameter(names={"-connect"}, required=true, description="Who to connect to. Syntax: localhost:4433")
    private String host = null;
    @Parameter(names={"-server_name"}, description="Server name for the SNI extension.")
    private String sniHostname = null;
    private String extractedHost = null;
    private int extractedPort = -1;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.extractParameters();
    }

    @Override
    public void applyDelegate(Config config) {
        this.extractParameters();
        config.setDefaultRunningMode(RunningModeType.CLIENT);
        OutboundConnection con = config.getDefaultClientConnection();
        if (con == null) {
            con = new OutboundConnection();
            config.setDefaultClientConnection(con);
        }
        LOGGER.info("Processing client delegate host={} sniHostname={}", (Object)this.host, (Object)this.sniHostname);
        con.setPort(this.extractedPort);
        if (IPAddress.isValid((String)this.extractedHost)) {
            con.setIp(this.extractedHost);
            if (IPAddress.isValidIPv6((String)this.extractedHost)) {
                con.setIpv6(this.extractedHost);
            } else if (this.sniHostname != null) {
                try {
                    con.setIpv6(this.getIpv6ForHost(this.sniHostname));
                }
                catch (UnknownHostException ex) {
                    LOGGER.warn("Could not resolve IPv6 address for host {}", (Object)this.sniHostname);
                    LOGGER.debug((Object)ex);
                }
            }
            this.setHostname(config, this.extractedHost, con);
            if (this.sniHostname != null) {
                this.setHostname(config, this.sniHostname, con);
            }
        } else {
            if (this.sniHostname != null) {
                this.setHostname(config, this.sniHostname, con);
            } else {
                this.setHostname(config, this.extractedHost, con);
            }
            con.setIp(this.getIpForHost(this.extractedHost));
            try {
                con.setIpv6(this.getIpv6ForHost(this.extractedHost));
            }
            catch (UnknownHostException ex) {
                LOGGER.warn("Could not resolve IPv6 address for host {}", (Object)this.extractedHost, (Object)ex);
            }
        }
    }

    public void setHostname(Config config, String hostname, OutboundConnection connection) {
        connection.setHostname(hostname);
        config.setDefaultSniHostnames(new LinkedList<ServerNamePair>(List.of(new ServerNamePair(config.getSniType().getValue(), hostname.getBytes(StandardCharsets.US_ASCII)))));
    }

    private void extractParameters() {
        URI uri;
        if (this.host == null) {
            throw new ParameterException("Could not parse provided host: " + this.host);
        }
        String[] split = this.host.split("://");
        if (split.length > 0) {
            this.host = split[split.length - 1];
        }
        this.host = IDN.toASCII(this.host);
        try {
            uri = new URI("my://" + this.host);
        }
        catch (URISyntaxException ex) {
            throw new ParameterException("Could not parse host '" + this.host + "'", (Throwable)ex);
        }
        if (uri.getHost() == null) {
            throw new ParameterException("Provided host seems invalid:" + this.host);
        }
        this.extractedPort = uri.getPort() <= 0 ? 443 : uri.getPort();
        this.extractedHost = uri.getHost();
    }

    private String getIpForHost(String host) {
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException ex) {
            LOGGER.warn("Could not resolve host \"{}\" returning anyways", (Object)host, (Object)ex);
            return host;
        }
    }

    public String getIpv6ForHost(String host) throws UnknownHostException {
        if (Objects.equals(host, "localhost")) {
            return InetAddress.getByName("::1").getHostAddress();
        }
        for (InetAddress addr : InetAddress.getAllByName(host)) {
            if (!(addr instanceof Inet6Address)) continue;
            return addr.getHostAddress();
        }
        throw new UnknownHostException();
    }

    public String getSniHostname() {
        return this.sniHostname;
    }

    public void setSniHostname(String sniHostname) {
        this.sniHostname = sniHostname;
    }

    public String getExtractedHost() {
        if (this.host != null && this.extractedHost == null) {
            this.extractParameters();
        }
        return this.extractedHost;
    }

    public int getExtractedPort() {
        if (this.host != null && this.extractedPort == -1) {
            this.extractParameters();
        }
        return this.extractedPort;
    }
}

