/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.connection.InboundConnection;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.layer.constant.StackConfiguration;
import de.rub.nds.tlsattacker.core.workflow.action.executor.WorkflowExecutorType;
import de.rub.nds.tlsattacker.transport.TransportHandlerType;

public class ProtocolVersionDelegate
extends Delegate {
    @Parameter(names={"-version"}, description="Highest supported protocol version ")
    private ProtocolVersion protocolVersion = null;

    public ProtocolVersionDelegate() {
    }

    public ProtocolVersionDelegate(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @Override
    public void applyDelegate(Config config) {
        if (this.protocolVersion == null) {
            return;
        }
        config.setHighestProtocolVersion(this.protocolVersion);
        config.setDefaultSelectedProtocolVersion(this.protocolVersion);
        TransportHandlerType th = TransportHandlerType.TCP;
        if (config.getHighestProtocolVersion().isDTLS()) {
            th = TransportHandlerType.UDP;
            config.setDefaultLayerConfiguration(StackConfiguration.DTLS);
            config.setWorkflowExecutorType(WorkflowExecutorType.DTLS);
            config.setFinishWithCloseNotify(true);
            config.setIgnoreRetransmittedCssInDtls(true);
        }
        if (this.protocolVersion.isTLS13()) {
            config.setAddSupportedVersionsExtension(true);
            config.setAddKeyShareExtension(true);
            config.setAddSignatureAndHashAlgorithmsExtension(true);
            if (!config.getSupportedVersions().contains((Object)ProtocolVersion.TLS13)) {
                config.getSupportedVersions().add(ProtocolVersion.TLS13);
            }
        }
        if (config.getDefaultClientConnection() == null) {
            config.setDefaultClientConnection(new OutboundConnection());
        }
        if (config.getDefaultServerConnection() == null) {
            config.setDefaultServerConnection(new InboundConnection());
        }
        config.getDefaultClientConnection().setTransportHandlerType(th);
        config.getDefaultServerConnection().setTransportHandlerType(th);
    }
}

