/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.constants.AlpnProtocol;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.constants.SniType;
import de.rub.nds.tlsattacker.core.layer.constant.StackConfiguration;
import de.rub.nds.tlsattacker.core.protocol.message.extension.quic.QuicTransportParameters;
import de.rub.nds.tlsattacker.core.workflow.action.executor.WorkflowExecutorType;
import de.rub.nds.tlsattacker.transport.TransportHandlerType;
import java.util.ArrayList;

public class QuicDelegate
extends Delegate {
    @Parameter(names={"-quic"}, description="Scan QUIC")
    private boolean quic = false;

    public QuicDelegate() {
    }

    public QuicDelegate(boolean isQuic) {
        this.quic = isQuic;
    }

    public boolean isQuic() {
        return this.quic;
    }

    public void setQuic(boolean quic) {
        this.quic = quic;
    }

    @Override
    public void applyDelegate(Config config) throws ConfigurationException {
        if (this.quic) {
            config.setQuic(true);
            config.getDefaultClientConnection().setTimeout(5000);
            config.getDefaultClientConnection().setTransportHandlerType(TransportHandlerType.UDP);
            config.getDefaultServerConnection().setTransportHandlerType(TransportHandlerType.UDP);
            config.setDefaultLayerConfiguration(StackConfiguration.QUIC);
            config.setWorkflowExecutorType(WorkflowExecutorType.QUIC);
            config.setFinishWithCloseNotify(true);
            config.setHighestProtocolVersion(ProtocolVersion.TLS13);
            config.setDefaultSelectedProtocolVersion(ProtocolVersion.TLS13);
            config.setSupportedVersions(ProtocolVersion.TLS13);
            config.setDefaultLastRecordProtocolVersion(ProtocolVersion.TLS13);
            config.setTls13BackwardsCompatibilityMode(false);
            config.setDefaultClientSupportedCipherSuites(CipherSuite.getTls13CipherSuites());
            config.setDefaultClientNamedGroups(NamedGroup.SECP256R1);
            config.setDefaultServerNamedGroups(NamedGroup.SECP256R1);
            config.setDefaultSelectedNamedGroup(NamedGroup.SECP256R1);
            config.setDefaultClientKeyShareNamedGroups(NamedGroup.SECP256R1);
            config.setDefaultClientSupportedSignatureAndHashAlgorithms(SignatureAndHashAlgorithm.getImplementedTls13SignatureAndHashAlgorithms());
            config.setDefaultServerSupportedCertificateSignAlgorithms(SignatureAndHashAlgorithm.getImplementedTls13SignatureAndHashAlgorithms());
            config.setAddServerNameIndicationExtension(true);
            config.setSniType(SniType.HOST_NAME);
            config.setAddECPointFormatExtension(false);
            config.setAddSupportedVersionsExtension(true);
            config.setAddEllipticCurveExtension(true);
            config.setAddSignatureAndHashAlgorithmsExtension(true);
            config.setAddKeyShareExtension(true);
            config.setAddPSKKeyExchangeModesExtension(true);
            config.setAddRenegotiationInfoExtension(false);
            config.setAddAlpnExtension(true);
            config.setQuicTransportParametersExtension(true);
            ArrayList<String> alpnEntries = new ArrayList<String>();
            alpnEntries.add(AlpnProtocol.HTTP3.getConstant());
            alpnEntries.add("h3-27");
            alpnEntries.add("h3-28");
            alpnEntries.add("h3-29");
            alpnEntries.add("hq-29");
            alpnEntries.add("echo");
            alpnEntries.add("hq-interop");
            config.setDefaultProposedAlpnProtocols(alpnEntries);
            QuicTransportParameters parameters = QuicTransportParameters.getDefaultParameters();
            config.setDefaultQuicTransportParameters(parameters);
        }
    }
}

