/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.constants.RecordSizeLimit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecordSizeLimitDelegate
extends Delegate {
    private static final Logger LOGGER = LogManager.getLogger();
    @Parameter(names={"-record_size_limit"}, description="Record size limit to be advertised in the corresponding TLS extension (0 < value < 65536)")
    private Integer recordSizeLimit = null;

    public Integer getRecordSizeLimit() {
        return this.recordSizeLimit;
    }

    public void setRecordSizeLimit(Integer recordSizeLimit) {
        this.recordSizeLimit = recordSizeLimit;
    }

    @Override
    public void applyDelegate(Config config) {
        if (this.recordSizeLimit == null) {
            return;
        }
        if (this.recordSizeLimit <= 0 || this.recordSizeLimit > RecordSizeLimit.MAX_RECORD_SIZE_LIMIT) {
            LOGGER.debug("-record_size_limit value (" + this.recordSizeLimit + ") is out of bounds, ignoring.");
            return;
        }
        config.setAddRecordSizeLimitExtension(true);
        config.setInboundRecordSizeLimit(this.recordSizeLimit);
        if (config.isAddMaxFragmentLengthExtension().booleanValue()) {
            LOGGER.warn("Configured to send record_size_limit and max_fragment_length simultaneously, resuming anyways");
        }
    }
}

