/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import java.util.Collections;
import java.util.List;

public class SignatureAndHashAlgorithmDelegate
extends Delegate {
    @Parameter(names={"-signature_hash_algo"}, description="Supported Signature and Hash Algorithms separated by comma eg. RSA_SHA512,DSA_SHA512")
    private List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms = null;

    public List<SignatureAndHashAlgorithm> getSignatureAndHashAlgorithms() {
        if (this.signatureAndHashAlgorithms == null) {
            return null;
        }
        return Collections.unmodifiableList(this.signatureAndHashAlgorithms);
    }

    public void setSignatureAndHashAlgorithms(List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms) {
        this.signatureAndHashAlgorithms = signatureAndHashAlgorithms;
    }

    @Override
    public void applyDelegate(Config config) {
        if (this.signatureAndHashAlgorithms != null) {
            config.setAddSignatureAndHashAlgorithmsExtension(true);
            config.setDefaultClientSupportedSignatureAndHashAlgorithms(this.signatureAndHashAlgorithms);
            config.setDefaultServerSupportedSignatureAndHashAlgorithms(this.signatureAndHashAlgorithms);
            config.setDefaultSelectedSignatureAndHashAlgorithm(this.signatureAndHashAlgorithms.get(0));
        }
    }
}

