/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.connection;

import de.rub.nds.protocol.exception.ConfigurationException;
import de.rub.nds.tlsattacker.core.connection.Aliasable;
import de.rub.nds.tlsattacker.transport.Connection;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.tlsattacker.transport.TransportHandlerType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@XmlType(propOrder={"alias", "ip", "ipv6", "port", "hostname", "proxyDataPort", "proxyDataHostname", "proxyControlPort", "proxyControlHostname", "timeout", "connectionTimeout", "transportHandlerType", "sourcePort", "useIpv6"})
public abstract class AliasedConnection
extends Connection
implements Aliasable {
    public static final String DEFAULT_CONNECTION_ALIAS = "defaultConnection";
    public static final TransportHandlerType DEFAULT_TRANSPORT_HANDLER_TYPE = TransportHandlerType.TCP;
    public static final Integer DEFAULT_TIMEOUT = 1000;
    public static final Integer DEFAULT_CONNECTION_TIMEOUT = 8000;
    public static final Integer DEFAULT_FIRST_TIMEOUT = DEFAULT_TIMEOUT;
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String DEFAULT_IP = "127.0.0.1";
    public static final Integer DEFAULT_PORT = 443;
    protected String alias = null;

    public AliasedConnection() {
    }

    public AliasedConnection(Integer port) {
        super(port);
    }

    public AliasedConnection(Integer port, String hostname) {
        super(port, hostname);
    }

    public AliasedConnection(String alias) {
        this.alias = alias;
    }

    public AliasedConnection(String alias, Integer port) {
        super(port);
        this.alias = alias;
    }

    public AliasedConnection(String alias, Integer port, String hostname) {
        super(port, hostname);
        this.alias = alias;
    }

    public AliasedConnection(AliasedConnection other) {
        super((Connection)other);
        this.alias = other.alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void assertAliasesSetProperly() throws ConfigurationException {
        if (this.alias == null || this.alias.isEmpty()) {
            throw new ConfigurationException("Empty or null alias in " + this.getClass().getSimpleName());
        }
    }

    public abstract String toCompactString();

    @Override
    public String aliasesToString() {
        return this.alias;
    }

    @Override
    public String getFirstAlias() {
        return this.alias;
    }

    @Override
    public Set<String> getAllAliases() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.alias);
        return set;
    }

    @Override
    public boolean containsAlias(String alias) {
        return this.alias.equals(alias);
    }

    @Override
    public boolean containsAllAliases(Collection<String> aliases) {
        if (aliases == null || aliases.isEmpty()) {
            return false;
        }
        if (aliases.size() == 1) {
            return this.alias.equals(aliases.iterator().next());
        }
        return false;
    }

    public String getDefaultConnectionAlias() {
        return DEFAULT_CONNECTION_ALIAS;
    }

    public abstract ConnectionEndType getLocalConnectionEndType();

    public int hashCode() {
        int hash = super.hashCode();
        hash = 41 * hash + Objects.hashCode(this.alias);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AliasedConnection other = (AliasedConnection)obj;
        return Objects.equals(this.alias, other.alias);
    }

    public void normalize(AliasedConnection defaultCon) {
        if (this.alias == null || this.alias.isEmpty()) {
            this.alias = defaultCon.getAlias();
            if (this.alias == null || this.alias.isEmpty()) {
                this.alias = this.getDefaultConnectionAlias();
            }
        }
        if (this.transportHandlerType == null) {
            this.transportHandlerType = defaultCon.getTransportHandlerType();
            if (this.transportHandlerType == null) {
                this.transportHandlerType = DEFAULT_TRANSPORT_HANDLER_TYPE;
            }
        }
        if (this.timeout == null) {
            this.timeout = defaultCon.getTimeout();
            if (this.timeout == null) {
                this.timeout = DEFAULT_TIMEOUT;
            }
        }
        if (this.connectionTimeout == null) {
            this.connectionTimeout = defaultCon.getConnectionTimeout();
            if (this.connectionTimeout == null) {
                this.connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
            }
        }
        if (this.hostname == null || this.hostname.isEmpty()) {
            this.hostname = defaultCon.getHostname();
            if (this.hostname == null || this.hostname.isEmpty()) {
                this.hostname = DEFAULT_HOSTNAME;
            }
        }
        if (this.ip == null || this.ip.isEmpty()) {
            this.ip = defaultCon.getHostname();
            if (this.ip == null || this.ip.isEmpty()) {
                this.ip = DEFAULT_IP;
            }
        }
        if (this.port == null) {
            this.port = defaultCon.getPort();
            if (this.port == null) {
                this.port = DEFAULT_PORT;
            }
            if (this.port < 0 || this.port > 65535) {
                throw new ConfigurationException("Attempt to set default port failed. Port must be in interval [0,65535], but is " + this.port);
            }
        }
        if (this.useIpv6 == null) {
            this.useIpv6 = defaultCon.getUseIpv6();
            if (this.useIpv6 == null) {
                this.useIpv6 = false;
            }
        }
    }

    public void filter(AliasedConnection defaultCon) {
        if (this.alias.equals(defaultCon.getAlias()) || this.alias.equals(this.getDefaultConnectionAlias())) {
            this.alias = null;
        }
        if (this.transportHandlerType == defaultCon.getTransportHandlerType() || this.transportHandlerType == DEFAULT_TRANSPORT_HANDLER_TYPE) {
            this.transportHandlerType = null;
        }
        if (Objects.equals(this.timeout, defaultCon.getTimeout()) || Objects.equals(this.timeout, DEFAULT_TIMEOUT)) {
            this.timeout = null;
        }
        if (this.hostname.equals(defaultCon.getHostname()) || Objects.equals(this.hostname, DEFAULT_HOSTNAME)) {
            this.hostname = null;
        }
        if (this.ip.equals(defaultCon.getHostname()) || Objects.equals(this.ip, DEFAULT_IP)) {
            this.ip = null;
        }
        if (Objects.equals(this.port, defaultCon.getPort()) || Objects.equals(this.port, DEFAULT_PORT)) {
            this.port = null;
        }
    }

    protected void addProperties(StringBuilder sb) {
        sb.append("alias=").append(this.alias).append(" ");
        super.addProperties(sb);
    }

    protected void addCompactProperties(StringBuilder sb) {
        sb.append(this.alias).append(":");
        super.addCompactProperties(sb);
    }

    public abstract AliasedConnection getCopy();
}

