/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.util.HashMap;
import java.util.Map;

public enum AlertLevel {
    UNDEFINED(0),
    WARNING(1),
    FATAL(2);

    private byte value;
    private static final Map<Byte, AlertLevel> MAP;

    private AlertLevel(byte value) {
        this.value = value;
    }

    public static AlertLevel getAlertLevel(byte value) {
        AlertLevel level = MAP.get(value);
        if (level == null) {
            level = UNDEFINED;
        }
        return level;
    }

    public byte getValue() {
        return this.value;
    }

    public byte[] getArrayValue() {
        return new byte[]{this.value};
    }

    public String toString() {
        return "AlertLevel{value=" + this.name() + "}";
    }

    static {
        MAP = new HashMap<Byte, AlertLevel>();
        for (AlertLevel cm : AlertLevel.values()) {
            MAP.put(cm.value, cm);
        }
    }
}

