/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public enum AuthzDataFormat {
    X509_ATTR_CERT(0),
    SAML_ASSERTION(1),
    X509_ATTR_CERT_URL(2),
    SAML_ASSERTION_URL(3);

    private final byte value;
    private static final Map<Byte, AuthzDataFormat> MAP;

    private AuthzDataFormat(byte value) {
        this.value = value;
    }

    public static AuthzDataFormat getDataFormat(byte value) {
        return MAP.get(value);
    }

    public byte getValue() {
        return this.value;
    }

    public static byte[] listToByteArray(List<AuthzDataFormat> list) {
        try (SilentByteArrayOutputStream bytes = new SilentByteArrayOutputStream(list.size());){
            for (AuthzDataFormat f : list) {
                bytes.write((int)f.getValue());
            }
            Object object = bytes.toByteArray();
            return object;
        }
    }

    public static List<AuthzDataFormat> byteArrayToList(byte[] values) {
        LinkedList<AuthzDataFormat> list = new LinkedList<AuthzDataFormat>();
        for (byte b : values) {
            list.add(AuthzDataFormat.getDataFormat(b));
        }
        return list;
    }

    static {
        MAP = new HashMap<Byte, AuthzDataFormat>();
        for (AuthzDataFormat c : AuthzDataFormat.values()) {
            MAP.put(c.getValue(), c);
        }
    }
}

