/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

public enum CipherAlgorithm {
    NULL(0, 0, 0, 0),
    RC2_40(5, 16, 8, 0, 8, "RC2/CBC/NoPadding"),
    RC2_128(16, null, 8, 0, 8, "RC2/CBC/NoPadding"),
    RC4_128(16, null, 0, 0, 0, "RC4"),
    DES_CBC(8, null, 8, 0, 8, "DES/CBC/NoPadding"),
    DES_EDE_CBC(24, null, 8, 0, 8, "DESede/CBC/NoPadding"),
    AES_128_CBC(16, null, 16, 0, 16, "AES/CBC/NoPadding"),
    AES_256_CBC(32, null, 16, 0, 16, "AES/CBC/NoPadding"),
    AES_128_GCM(16, null, 4, 8, 16, "AES/GCM/NoPadding"),
    AES_256_GCM(32, null, 4, 8, 16, "AES/GCM/NoPadding"),
    CAMELLIA_128_CBC(16, null, 16, 0, 16, "Camellia/CBC/NoPadding"),
    CAMELLIA_256_CBC(32, null, 16, 0, 16, "Camellia/CBC/NoPadding"),
    CAMELLIA_128_GCM(16, null, 16, 8, 16, "Camellia/GCM/NoPadding"),
    CAMELLIA_256_GCM(32, null, 16, 8, 16, "Camellia/GCM/NoPadding"),
    IDEA_128(16, null, 8, 0, 8, "IDEA/CBC/NoPadding"),
    SEED_CBC(16, null, 16, 0, 16, "SEED/CBC/NoPadding"),
    AES_128_CCM(16, null, 4, 8, 16, "AES/CCM/NoPadding"),
    AES_256_CCM(32, null, 4, 8, 16, "AES/CCM/NoPadding"),
    CHACHA20_POLY1305(32, null, 12, 0, 0, "ChaCha20-Poly1305"),
    UNOFFICIAL_CHACHA20_POLY1305(32, null, 12, 0, 0, "ChaCha20-Poly1305"),
    DES40_CBC(5, 8, 8, 0, 8, "DES/CBC/NoPadding"),
    ARIA_128_CBC(16, null, 16, 0, 16, "ARIA/CBC/NoPadding"),
    ARIA_256_CBC(32, null, 16, 0, 16, "ARIA/CBC/NoPadding"),
    ARIA_128_GCM(16, null, 16, 8, 16, "ARIA/GCM/NoPadding"),
    ARIA_256_GCM(32, null, 16, 8, 16, "ARIA/GCM/NoPadding"),
    GOST_28147_CNT_IMIT(32, null, 8, 0, 8, "GOST28147/ECB/NoPadding"),
    FORTEZZA_CBC(0, 0, 0, 0),
    AES_128_CTR(16, null, 16, 0, 0, "AES/CTR/NoPadding"),
    AES_256_CTR(32, null, 16, 0, 0, "AES/CTR/NoPadding"),
    RABBIT_CBC(16, 8, 0, 8),
    SM4_GCM(16, null, 4, 8, 16, "SM4/GCM/NoPadding"),
    SM4_CCM(16, null, 4, 8, 16, "SM4/CCM/NoPadding"),
    RC4_40(5, 16, 0, 0, 0, "RC4"),
    RC4_56(7, 16, 0, 0, 0, "RC4"),
    RC2_56(16, 7, 8, 0, 8, "RC2/CBC/NoPadding"),
    AES_128_CCM_8(16, null, 4, 8, 16, "AES/CCM/NoPadding"),
    AES_256_CCM_8(32, null, 4, 8, 16, "AES/CCM/NoPadding");

    private final int keySize;
    private final Integer exportFinalKeySize;
    private final int nonceBytesFromHandshake;
    private final int nonceBytesFromRecord;
    private final int blocksize;
    private final String javaName;

    private CipherAlgorithm(int keySize, Integer exportFinalKeySize, int nonceBytesFromHandshake, int nonceBytesFromRecord, int blocksize, String javaName) {
        this.keySize = keySize;
        this.exportFinalKeySize = exportFinalKeySize;
        this.javaName = javaName;
        this.nonceBytesFromHandshake = nonceBytesFromHandshake;
        this.nonceBytesFromRecord = nonceBytesFromRecord;
        this.blocksize = blocksize;
    }

    private CipherAlgorithm(int keySize, int nonceBytesFromHandshake, int nonceBytesFromRecord, int blocksize) {
        this.keySize = keySize;
        this.exportFinalKeySize = null;
        this.javaName = null;
        this.nonceBytesFromHandshake = nonceBytesFromHandshake;
        this.nonceBytesFromRecord = nonceBytesFromRecord;
        this.blocksize = blocksize;
    }

    public Integer getExportFinalKeySize() {
        return this.exportFinalKeySize;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public int getNonceBytesFromHandshake() {
        return this.nonceBytesFromHandshake;
    }

    public int getNonceBytesFromRecord() {
        return this.nonceBytesFromRecord;
    }

    public int getBlocksize() {
        return this.blocksize;
    }
}

