/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.protocol.constants.PointFormat;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum ECPointFormat {
    UNCOMPRESSED(0, PointFormat.UNCOMPRESSED),
    ANSIX962_COMPRESSED_PRIME(1, PointFormat.COMPRESSED),
    ANSIX962_COMPRESSED_CHAR2(2, PointFormat.COMPRESSED);

    private byte value;
    private PointFormat format;
    private static final Logger LOGGER;
    private static final Map<Byte, ECPointFormat> MAP;

    private ECPointFormat(byte value, PointFormat format) {
        this.value = value;
        this.format = format;
    }

    public static ECPointFormat getECPointFormat(byte value) {
        return MAP.get(value);
    }

    public PointFormat getFormat() {
        return this.format;
    }

    public byte getValue() {
        return this.value;
    }

    public static ECPointFormat getRandom(Random random) {
        ECPointFormat c = null;
        while (c == null) {
            Object[] o = MAP.values().toArray();
            c = (ECPointFormat)((Object)o[random.nextInt(o.length)]);
        }
        return c;
    }

    public byte[] getArrayValue() {
        return new byte[]{this.value};
    }

    public short getShortValue() {
        return (short)(this.value & 0xFF);
    }

    public static byte[] pointFormatsToByteArray(List<ECPointFormat> pointFormats) throws IOException {
        if (pointFormats == null || pointFormats.isEmpty()) {
            return new byte[0];
        }
        try (SilentByteArrayOutputStream bytes = new SilentByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream os = new ObjectOutputStream((OutputStream)bytes);){
                os.writeObject(pointFormats.toArray(new ECPointFormat[pointFormats.size()]));
                byArray = bytes.toByteArray();
            }
            return byArray;
        }
    }

    public static ECPointFormat[] pointFormatsFromByteArray(byte[] sourceBytes) {
        if (sourceBytes == null || sourceBytes.length == 0) {
            return null;
        }
        ArrayList<ECPointFormat> formats = new ArrayList<ECPointFormat>(sourceBytes.length);
        for (byte sourceByte : sourceBytes) {
            ECPointFormat format = ECPointFormat.getECPointFormat(sourceByte);
            if (format != null) {
                formats.add(format);
                continue;
            }
            LOGGER.warn("Ignoring unknown ECPointFormat {}", (Object)sourceByte);
        }
        return (ECPointFormat[])formats.toArray(ECPointFormat[]::new);
    }

    static {
        LOGGER = LogManager.getLogger();
        MAP = new HashMap<Byte, ECPointFormat>();
        for (ECPointFormat cm : ECPointFormat.values()) {
            MAP.put(cm.value, cm);
        }
    }
}

