/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public enum ExtensionType {
    SERVER_NAME_INDICATION(new byte[]{0, 0}),
    MAX_FRAGMENT_LENGTH(new byte[]{0, 1}),
    CLIENT_CERTIFICATE_URL(new byte[]{0, 2}),
    TRUSTED_CA_KEYS(new byte[]{0, 3}),
    TRUNCATED_HMAC(new byte[]{0, 4}),
    STATUS_REQUEST(new byte[]{0, 5}),
    USER_MAPPING(new byte[]{0, 6}),
    CLIENT_AUTHZ(new byte[]{0, 7}),
    SERVER_AUTHZ(new byte[]{0, 8}),
    CERT_TYPE(new byte[]{0, 9}),
    ELLIPTIC_CURVES(new byte[]{0, 10}),
    EC_POINT_FORMATS(new byte[]{0, 11}),
    SRP(new byte[]{0, 12}),
    SIGNATURE_AND_HASH_ALGORITHMS(new byte[]{0, 13}),
    USE_SRTP(new byte[]{0, 14}),
    HEARTBEAT(new byte[]{0, 15}),
    ALPN(new byte[]{0, 16}),
    STATUS_REQUEST_V2(new byte[]{0, 17}),
    SIGNED_CERTIFICATE_TIMESTAMP(new byte[]{0, 18}),
    CLIENT_CERTIFICATE_TYPE(new byte[]{0, 19}),
    SERVER_CERTIFICATE_TYPE(new byte[]{0, 20}),
    PADDING(new byte[]{0, 21}),
    ENCRYPT_THEN_MAC(new byte[]{0, 22}),
    EXTENDED_MASTER_SECRET(new byte[]{0, 23}),
    TOKEN_BINDING(new byte[]{0, 24}),
    CACHED_INFO(new byte[]{0, 25}),
    RECORD_SIZE_LIMIT(new byte[]{0, 28}),
    PWD_PROTECT(new byte[]{0, 29}),
    PWD_CLEAR(new byte[]{0, 30}),
    PASSWORD_SALT(new byte[]{0, 31}),
    SESSION_TICKET(new byte[]{0, 35}),
    EXTENDED_RANDOM(new byte[]{0, 40}),
    PRE_SHARED_KEY(new byte[]{0, 41}),
    EARLY_DATA(new byte[]{0, 42}),
    SUPPORTED_VERSIONS(new byte[]{0, 43}),
    COOKIE(new byte[]{0, 44}),
    PSK_KEY_EXCHANGE_MODES(new byte[]{0, 45}),
    CERTIFICATE_AUTHORITIES(new byte[]{0, 47}),
    OID_FILTERS(new byte[]{0, 48}),
    POST_HANDSHAKE_AUTH(new byte[]{0, 49}),
    SIGNATURE_ALGORITHMS_CERT(new byte[]{0, 50}),
    KEY_SHARE(new byte[]{0, 51}),
    RENEGOTIATION_INFO(new byte[]{-1, 1}),
    ENCRYPTED_SERVER_NAME_INDICATION(new byte[]{-1, -50}),
    QUIC_TRANSPORT_PARAMETERS(new byte[]{0, 57}),
    CONNECTION_ID(new byte[]{0, 54}),
    ENCRYPTED_CLIENT_HELLO_DRAFT_07(new byte[]{-1, 2}),
    ENCRYPTED_CLIENT_HELLO_DRAFT_08(new byte[]{-1, 8}),
    ENCRYPTED_CLIENT_HELLO_DRAFT_09(new byte[]{-1, 9}),
    ENCRYPTED_CLIENT_HELLO_DRAFT_10(new byte[]{-1, 10}),
    ENCRYPTED_CLIENT_HELLO_DRAFT_11(new byte[]{-1, 11}),
    ENCRYPTED_CLIENT_HELLO_DRAFT_12(new byte[]{-1, 12}),
    ENCRYPTED_CLIENT_HELLO(new byte[]{-2, 13}),
    DEBUG(new byte[]{-5, -5}),
    GREASE_00(new byte[]{10, 10}),
    GREASE_01(new byte[]{26, 26}),
    GREASE_02(new byte[]{42, 42}),
    GREASE_03(new byte[]{58, 58}),
    GREASE_04(new byte[]{74, 74}),
    GREASE_05(new byte[]{90, 90}),
    GREASE_06(new byte[]{106, 106}),
    GREASE_07(new byte[]{122, 122}),
    GREASE_08(new byte[]{-118, -118}),
    GREASE_09(new byte[]{-102, -102}),
    GREASE_10(new byte[]{-86, -86}),
    GREASE_11(new byte[]{-70, -70}),
    GREASE_12(new byte[]{-54, -54}),
    GREASE_13(new byte[]{-38, -38}),
    GREASE_14(new byte[]{-22, -22}),
    GREASE_15(new byte[]{-6, -6}),
    UNKNOWN(new byte[0]);

    private byte[] value;
    private static final Map<Integer, ExtensionType> MAP;

    private ExtensionType(byte[] value) {
        this.value = value;
    }

    private static int valueToInt(byte[] value) {
        if (value.length == 2) {
            return (value[0] & 0xFF) << 8 | value[1] & 0xFF;
        }
        return -1;
    }

    public static ExtensionType getExtensionType(byte[] value) {
        ExtensionType type = MAP.get(ExtensionType.valueToInt(value));
        if (type == null) {
            return UNKNOWN;
        }
        return type;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte getMajor() {
        return this.value[0];
    }

    public byte getMinor() {
        return this.value[1];
    }

    public boolean isGrease() {
        return this.name().contains("GREASE");
    }

    public static List<ExtensionType> getSendable() {
        LinkedList<ExtensionType> list = new LinkedList<ExtensionType>();
        list.add(ALPN);
        list.add(CACHED_INFO);
        list.add(CERT_TYPE);
        list.add(CLIENT_AUTHZ);
        list.add(CLIENT_CERTIFICATE_TYPE);
        list.add(CLIENT_CERTIFICATE_URL);
        list.add(EARLY_DATA);
        list.add(EC_POINT_FORMATS);
        list.add(ELLIPTIC_CURVES);
        list.add(ENCRYPT_THEN_MAC);
        list.add(EXTENDED_MASTER_SECRET);
        list.add(HEARTBEAT);
        list.add(KEY_SHARE);
        list.add(EXTENDED_RANDOM);
        list.add(MAX_FRAGMENT_LENGTH);
        list.add(PADDING);
        list.add(PRE_SHARED_KEY);
        list.add(PSK_KEY_EXCHANGE_MODES);
        list.add(RENEGOTIATION_INFO);
        list.add(SERVER_AUTHZ);
        list.add(SERVER_CERTIFICATE_TYPE);
        list.add(SERVER_NAME_INDICATION);
        list.add(SESSION_TICKET);
        list.add(SIGNATURE_AND_HASH_ALGORITHMS);
        list.add(SIGNATURE_ALGORITHMS_CERT);
        list.add(SIGNED_CERTIFICATE_TIMESTAMP);
        list.add(SRP);
        list.add(STATUS_REQUEST);
        list.add(STATUS_REQUEST_V2);
        list.add(SUPPORTED_VERSIONS);
        list.add(TOKEN_BINDING);
        list.add(TRUNCATED_HMAC);
        list.add(TRUSTED_CA_KEYS);
        list.add(USE_SRTP);
        list.add(COOKIE);
        list.add(RECORD_SIZE_LIMIT);
        list.add(CONNECTION_ID);
        list.add(QUIC_TRANSPORT_PARAMETERS);
        list.add(ENCRYPTED_CLIENT_HELLO);
        return list;
    }

    public static List<ExtensionType> getReceivable() {
        LinkedList<ExtensionType> list = new LinkedList<ExtensionType>();
        list.add(ALPN);
        list.add(CACHED_INFO);
        list.add(CERT_TYPE);
        list.add(CLIENT_AUTHZ);
        list.add(CLIENT_CERTIFICATE_TYPE);
        list.add(CLIENT_CERTIFICATE_URL);
        list.add(EARLY_DATA);
        list.add(EC_POINT_FORMATS);
        list.add(ELLIPTIC_CURVES);
        list.add(ENCRYPT_THEN_MAC);
        list.add(EXTENDED_MASTER_SECRET);
        list.add(HEARTBEAT);
        list.add(KEY_SHARE);
        list.add(EXTENDED_RANDOM);
        list.add(MAX_FRAGMENT_LENGTH);
        list.add(PADDING);
        list.add(PRE_SHARED_KEY);
        list.add(PSK_KEY_EXCHANGE_MODES);
        list.add(RENEGOTIATION_INFO);
        list.add(SERVER_AUTHZ);
        list.add(SERVER_CERTIFICATE_TYPE);
        list.add(SERVER_NAME_INDICATION);
        list.add(SESSION_TICKET);
        list.add(SIGNATURE_AND_HASH_ALGORITHMS);
        list.add(SIGNATURE_ALGORITHMS_CERT);
        list.add(SIGNED_CERTIFICATE_TIMESTAMP);
        list.add(SRP);
        list.add(STATUS_REQUEST);
        list.add(STATUS_REQUEST_V2);
        list.add(SUPPORTED_VERSIONS);
        list.add(TOKEN_BINDING);
        list.add(TRUNCATED_HMAC);
        list.add(TRUSTED_CA_KEYS);
        list.add(USE_SRTP);
        list.add(COOKIE);
        list.add(RECORD_SIZE_LIMIT);
        list.add(CONNECTION_ID);
        list.add(QUIC_TRANSPORT_PARAMETERS);
        list.add(ENCRYPTED_CLIENT_HELLO);
        return list;
    }

    public static List<ExtensionType> getImplemented() {
        LinkedList<ExtensionType> list = new LinkedList<ExtensionType>();
        list.add(EARLY_DATA);
        list.add(EC_POINT_FORMATS);
        list.add(ELLIPTIC_CURVES);
        list.add(EXTENDED_MASTER_SECRET);
        list.add(KEY_SHARE);
        list.add(MAX_FRAGMENT_LENGTH);
        list.add(PADDING);
        list.add(PRE_SHARED_KEY);
        list.add(PSK_KEY_EXCHANGE_MODES);
        list.add(SERVER_NAME_INDICATION);
        list.add(SIGNATURE_AND_HASH_ALGORITHMS);
        list.add(SIGNATURE_ALGORITHMS_CERT);
        list.add(SUPPORTED_VERSIONS);
        list.add(TOKEN_BINDING);
        list.add(RENEGOTIATION_INFO);
        list.add(HEARTBEAT);
        list.add(EXTENDED_RANDOM);
        list.add(COOKIE);
        list.add(RECORD_SIZE_LIMIT);
        list.add(CONNECTION_ID);
        list.add(ENCRYPTED_CLIENT_HELLO);
        return list;
    }

    public static boolean allowedInEncryptedExtensions(ExtensionType extType) {
        switch (extType.ordinal()) {
            case 0: 
            case 1: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 26: 
            case 33: 
            case 44: {
                return true;
            }
        }
        return false;
    }

    public static List<ExtensionType> getNonTls13Extensions() {
        LinkedList<ExtensionType> list = new LinkedList<ExtensionType>();
        list.add(EXTENDED_MASTER_SECRET);
        list.add(EXTENDED_RANDOM);
        list.add(ENCRYPT_THEN_MAC);
        list.add(SRP);
        list.add(TRUNCATED_HMAC);
        list.add(RENEGOTIATION_INFO);
        return list;
    }

    public static List<ExtensionType> getTls13OnlyExtensions() {
        LinkedList<ExtensionType> list = new LinkedList<ExtensionType>();
        list.add(EARLY_DATA);
        list.add(KEY_SHARE);
        return list;
    }

    static {
        MAP = new HashMap<Integer, ExtensionType>();
        for (ExtensionType c : ExtensionType.values()) {
            MAP.put(ExtensionType.valueToInt(c.value), c);
        }
    }
}

