/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.util.HashMap;
import java.util.Map;

public enum HandshakeMessageType {
    UNKNOWN(-1),
    HELLO_REQUEST(0),
    CLIENT_HELLO(1),
    SERVER_HELLO(2),
    HELLO_VERIFY_REQUEST(3),
    NEW_SESSION_TICKET(4),
    END_OF_EARLY_DATA(5),
    ENCRYPTED_EXTENSIONS(8),
    REQUEST_CONNECTION_ID(9),
    NEW_CONNECTION_ID(10),
    CERTIFICATE(11),
    SERVER_KEY_EXCHANGE(12),
    CERTIFICATE_REQUEST(13),
    SERVER_HELLO_DONE(14),
    CERTIFICATE_VERIFY(15),
    CLIENT_KEY_EXCHANGE(16),
    FINISHED(20),
    KEY_UPDATE(24),
    CERTIFICATE_STATUS(22),
    SUPPLEMENTAL_DATA(23),
    MESSAGE_HASH(-2);

    private int value;
    private static final Map<Byte, HandshakeMessageType> MAP;

    private HandshakeMessageType(byte value) {
        this.value = value;
    }

    private HandshakeMessageType() {
        this.value = -1;
    }

    public static HandshakeMessageType getMessageType(byte value) {
        HandshakeMessageType type = MAP.get(value);
        if (type == null) {
            type = UNKNOWN;
        }
        return type;
    }

    public byte getValue() {
        return (byte)this.value;
    }

    public byte[] getArrayValue() {
        return new byte[]{(byte)this.value};
    }

    public String getName() {
        return this.name();
    }

    static {
        MAP = new HashMap<Byte, HandshakeMessageType>();
        for (HandshakeMessageType cm : HandshakeMessageType.values()) {
            if (cm == UNKNOWN || cm.name().contains("SSL2")) continue;
            MAP.put((byte)cm.value, cm);
        }
    }
}

