/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

public enum KeyExchangeAlgorithm {
    NULL,
    DHE_DSS,
    DHE_RSA,
    DHE_PSK,
    DH_ANON,
    RSA,
    RSA_EXPORT,
    RSA_PSK,
    DH_DSS,
    DH_RSA,
    KRB5,
    SRP_SHA_DSS,
    SRP_SHA_RSA,
    SRP_SHA,
    PSK,
    ECDH_RSA,
    ECDH_ANON,
    ECDH_ECDSA,
    ECDHE_ECDSA,
    ECDHE_RSA,
    ECDHE_PSK,
    VKO_GOST94,
    VKO_GOST01,
    VKO_GOST12,
    FORTEZZA_KEA,
    ECMQV_ECDSA,
    ECMQV_ECNRA,
    ECDH_ECNRA,
    CECPQ1_ECDSA,
    ECCPWD,
    CECPQ1_RSA,
    GOSTR341112_256;


    public boolean isKeyExchangeRsa() {
        switch (this.ordinal()) {
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isKeyExchangeDh() {
        switch (this.ordinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public boolean isKeyExchangeStaticDh() {
        switch (this.ordinal()) {
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public boolean isSrp() {
        switch (this.ordinal()) {
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public boolean isKeyExchangeDhe() {
        switch (this.ordinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public boolean isKeyExchangeEcdhe() {
        switch (this.ordinal()) {
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public boolean isKeyExchangeEcdh() {
        switch (this.ordinal()) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    public boolean isKeyExchangeStaticEcdh() {
        switch (this.ordinal()) {
            case 15: 
            case 17: 
            case 27: {
                return true;
            }
        }
        return false;
    }

    public boolean isKeyExchangeEphemeralEcdh() {
        switch (this.ordinal()) {
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public boolean isKeyExchangeEphemeral() {
        switch (this.ordinal()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public boolean isEC() {
        switch (this.ordinal()) {
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
        }
        return false;
    }

    public boolean isAnon() {
        switch (this.ordinal()) {
            case 4: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public boolean isPsk() {
        switch (this.ordinal()) {
            case 3: 
            case 7: 
            case 14: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public boolean isExport() {
        return this.name().contains("EXPORT");
    }

    public boolean requiresCertificate() {
        switch (this.ordinal()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return true;
            }
            case 0: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 16: 
            case 20: 
            case 24: 
            case 29: {
                return false;
            }
        }
        throw new UnsupportedOperationException(this.name() + " not defined yet! Please ask the developers to add this KEX algorithm");
    }

    public boolean isDss() {
        switch (this.ordinal()) {
            case 1: 
            case 8: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean isGost() {
        switch (this.ordinal()) {
            case 21: 
            case 22: 
            case 23: 
            case 31: {
                return true;
            }
        }
        return false;
    }

    public boolean isEcdsa() {
        switch (this.ordinal()) {
            case 17: 
            case 18: 
            case 25: 
            case 28: {
                return true;
            }
        }
        return false;
    }
}

