/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public enum MaxFragmentLength {
    TWO_9(1, 512),
    TWO_10(2, 1024),
    TWO_11(3, 2048),
    TWO_12(4, 4096);

    private byte value;
    private int lengthValue;
    private static final Map<Byte, MaxFragmentLength> MAP;

    private MaxFragmentLength(byte value, int lengthValue) {
        this.value = value;
        this.lengthValue = lengthValue;
    }

    public static MaxFragmentLength getMaxFragmentLength(byte value) {
        return MAP.get(value);
    }

    public byte getValue() {
        return this.value;
    }

    public byte[] getArrayValue() {
        return new byte[]{this.value};
    }

    public static MaxFragmentLength getRandom(Random random) {
        MaxFragmentLength c = null;
        while (c == null) {
            Object[] o = MAP.values().toArray();
            c = (MaxFragmentLength)((Object)o[random.nextInt(o.length)]);
        }
        return c;
    }

    public int getReceiveLimit() {
        return this.lengthValue;
    }

    static {
        MAP = new HashMap<Byte, MaxFragmentLength>();
        for (MaxFragmentLength cm : MaxFragmentLength.values()) {
            MAP.put(cm.value, cm);
        }
    }
}

