/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.protocol.constants.EcCurveEquationType;
import de.rub.nds.protocol.constants.FfdhGroupParameters;
import de.rub.nds.protocol.constants.GroupParameters;
import de.rub.nds.protocol.constants.NamedEllipticCurveParameters;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ffdh.Rfc7919Group2048;
import de.rub.nds.protocol.crypto.ffdh.Rfc7919Group3072;
import de.rub.nds.protocol.crypto.ffdh.Rfc7919Group4096;
import de.rub.nds.protocol.crypto.ffdh.Rfc7919Group6144;
import de.rub.nds.protocol.crypto.ffdh.Rfc7919Group8192;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.x509attacker.constants.X509NamedCurve;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum NamedGroup {
    SECT163K1(new byte[]{0, 1}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT163K1),
    SECT163R1(new byte[]{0, 2}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT163R1),
    SECT163R2(new byte[]{0, 3}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT163R2),
    SECT193R1(new byte[]{0, 4}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT193R1),
    SECT193R2(new byte[]{0, 5}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT193R2),
    SECT233K1(new byte[]{0, 6}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT233K1),
    SECT233R1(new byte[]{0, 7}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT233R1),
    SECT239K1(new byte[]{0, 8}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT239K1),
    SECT283K1(new byte[]{0, 9}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT283K1),
    SECT283R1(new byte[]{0, 10}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT283R1),
    SECT409K1(new byte[]{0, 11}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT409K1),
    SECT409R1(new byte[]{0, 12}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT409R1),
    SECT571K1(new byte[]{0, 13}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT571K1),
    SECT571R1(new byte[]{0, 14}, (GroupParameters<?>)NamedEllipticCurveParameters.SECT571R1),
    SECP160K1(new byte[]{0, 15}, (GroupParameters<?>)NamedEllipticCurveParameters.SECP160K1),
    SECP160R1(new byte[]{0, 16}, (GroupParameters<?>)NamedEllipticCurveParameters.SECP160R1),
    SECP160R2(new byte[]{0, 17}, (GroupParameters<?>)NamedEllipticCurveParameters.SECP160R2),
    SECP192K1(new byte[]{0, 18}, (GroupParameters<?>)NamedEllipticCurveParameters.SECP192K1),
    SECP192R1(new byte[]{0, 19}, (GroupParameters<?>)NamedEllipticCurveParameters.SECP192R1),
    SECP224K1(new byte[]{0, 20}, (GroupParameters<?>)NamedEllipticCurveParameters.SECP224K1),
    SECP224R1(new byte[]{0, 21}, (GroupParameters<?>)NamedEllipticCurveParameters.SECP224R1),
    SECP256K1(new byte[]{0, 22}, (GroupParameters<?>)NamedEllipticCurveParameters.SECP256K1),
    SECP256R1(new byte[]{0, 23}, (GroupParameters<?>)NamedEllipticCurveParameters.SECP256R1),
    SECP384R1(new byte[]{0, 24}, (GroupParameters<?>)NamedEllipticCurveParameters.SECP384R1),
    SECP521R1(new byte[]{0, 25}, (GroupParameters<?>)NamedEllipticCurveParameters.SECP521R1),
    BRAINPOOLP256R1(new byte[]{0, 26}, (GroupParameters<?>)NamedEllipticCurveParameters.BRAINPOOLP256R1),
    BRAINPOOLP384R1(new byte[]{0, 27}, (GroupParameters<?>)NamedEllipticCurveParameters.BRAINPOOLP384R1),
    BRAINPOOLP512R1(new byte[]{0, 28}, (GroupParameters<?>)NamedEllipticCurveParameters.BRAINPOOLP512R1),
    ECDH_X25519(new byte[]{0, 29}, (GroupParameters<?>)NamedEllipticCurveParameters.CURVE_X25519),
    ECDH_X448(new byte[]{0, 30}, (GroupParameters<?>)NamedEllipticCurveParameters.CURVE_X448),
    BRAINPOOLP256R1TLS13(new byte[]{0, 31}, (GroupParameters<?>)NamedEllipticCurveParameters.BRAINPOOLP256R1),
    BRAINPOOLP384R1TLS13(new byte[]{0, 32}, (GroupParameters<?>)NamedEllipticCurveParameters.BRAINPOOLP384R1),
    BRAINPOOLP512R1TLS13(new byte[]{0, 33}, (GroupParameters<?>)NamedEllipticCurveParameters.BRAINPOOLP512R1),
    GC256A(new byte[]{0, 34}, null),
    GC256B(new byte[]{0, 35}, null),
    GC256C(new byte[]{0, 36}, null),
    GC256D(new byte[]{0, 37}, null),
    GC512A(new byte[]{0, 38}, null),
    GC512B(new byte[]{0, 39}, null),
    GC512C(new byte[]{0, 40}, null),
    CURVE_SM2(new byte[]{0, 41}, (GroupParameters<?>)NamedEllipticCurveParameters.CURVE_SM2),
    FFDHE2048(new byte[]{1, 0}, (GroupParameters<?>)new Rfc7919Group2048()),
    FFDHE3072(new byte[]{1, 1}, (GroupParameters<?>)new Rfc7919Group3072()),
    FFDHE4096(new byte[]{1, 2}, (GroupParameters<?>)new Rfc7919Group4096()),
    FFDHE6144(new byte[]{1, 3}, (GroupParameters<?>)new Rfc7919Group6144()),
    FFDHE8192(new byte[]{1, 4}, (GroupParameters<?>)new Rfc7919Group8192()),
    MLKEM512(new byte[]{2, 0}, null),
    MLKEM768(new byte[]{2, 1}, null),
    MLKEM1024(new byte[]{2, 2}, null),
    SECP256R1_MLKEM768(new byte[]{17, -21}, null),
    X25519_MLKEM768(new byte[]{17, -20}, null),
    SECP384R1_MLKEM1024(new byte[]{17, -19}, null),
    X25519_KYBER768_DRAFT00(new byte[]{99, -103}, null),
    EXPLICIT_PRIME(new byte[]{-1, 1}, null),
    EXPLICIT_CHAR2(new byte[]{-1, 2}, null),
    GREASE_00(new byte[]{10, 10}, null),
    GREASE_01(new byte[]{26, 26}, null),
    GREASE_02(new byte[]{42, 42}, null),
    GREASE_03(new byte[]{58, 58}, null),
    GREASE_04(new byte[]{74, 74}, null),
    GREASE_05(new byte[]{90, 90}, null),
    GREASE_06(new byte[]{106, 106}, null),
    GREASE_07(new byte[]{122, 122}, null),
    GREASE_08(new byte[]{-118, -118}, null),
    GREASE_09(new byte[]{-102, -102}, null),
    GREASE_10(new byte[]{-86, -86}, null),
    GREASE_11(new byte[]{-70, -70}, null),
    GREASE_12(new byte[]{-54, -54}, null),
    GREASE_13(new byte[]{-38, -38}, null),
    GREASE_14(new byte[]{-22, -22}, null),
    GREASE_15(new byte[]{-6, -6}, null);

    private static final Logger LOGGER;
    private byte[] value;
    private GroupParameters<?> groupParameters;
    private static final Map<ByteBuffer, NamedGroup> MAP;
    private static final Set<NamedGroup> tls13Groups;

    private NamedGroup(byte[] value, GroupParameters<?> group) {
        this.value = value;
        this.groupParameters = group;
    }

    public static NamedGroup getNamedGroup(byte[] value) {
        return MAP.get(ByteBuffer.wrap(value));
    }

    public X509NamedCurve convertToX509() {
        switch (this.ordinal()) {
            case 25: {
                return X509NamedCurve.BRAINPOOLP256R1;
            }
            case 26: {
                return X509NamedCurve.BRAINPOOLP384R1;
            }
            case 27: {
                return X509NamedCurve.BRAINPOOLP512R1;
            }
            case 28: 
            case 29: {
                return null;
            }
            case 53: 
            case 54: {
                return null;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return null;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return null;
            }
            case 14: {
                return X509NamedCurve.SECP160K1;
            }
            case 15: {
                return X509NamedCurve.SECP160R1;
            }
            case 16: {
                return X509NamedCurve.SECP160R2;
            }
            case 17: {
                return X509NamedCurve.SECP192K1;
            }
            case 18: {
                return X509NamedCurve.SECP192R1;
            }
            case 19: {
                return X509NamedCurve.SECP224K1;
            }
            case 20: {
                return X509NamedCurve.SECP224R1;
            }
            case 21: {
                return X509NamedCurve.SECP256K1;
            }
            case 22: {
                return X509NamedCurve.SECP256R1;
            }
            case 23: {
                return X509NamedCurve.SECP384R1;
            }
            case 24: {
                return X509NamedCurve.SECP521R1;
            }
            case 0: {
                return X509NamedCurve.SECT163K1;
            }
            case 1: {
                return X509NamedCurve.SECT163R1;
            }
            case 2: {
                return X509NamedCurve.SECT163R2;
            }
            case 3: {
                return X509NamedCurve.SECT193R1;
            }
            case 4: {
                return X509NamedCurve.SECT193R2;
            }
            case 5: {
                return X509NamedCurve.SECT233K1;
            }
            case 6: {
                return X509NamedCurve.SECT233R1;
            }
            case 7: {
                return X509NamedCurve.SECT239K1;
            }
            case 8: {
                return X509NamedCurve.SECT283K1;
            }
            case 9: {
                return X509NamedCurve.SECT283R1;
            }
            case 10: {
                return X509NamedCurve.SECT409K1;
            }
            case 11: {
                return X509NamedCurve.SECT409R1;
            }
            case 12: {
                return X509NamedCurve.SECT571K1;
            }
            case 13: {
                return X509NamedCurve.SECT571R1;
            }
        }
        return null;
    }

    public static NamedGroup convertFromX509NamedCurve(X509NamedCurve curve) {
        switch (curve) {
            case BRAINPOOLP160R1: {
                return null;
            }
            case BRAINPOOLP160T1: {
                return null;
            }
            case BRAINPOOLP192R1: {
                return null;
            }
            case BRAINPOOLP192T1: {
                return null;
            }
            case BRAINPOOLP224R1: {
                return null;
            }
            case BRAINPOOLP224T1: {
                return null;
            }
            case BRAINPOOLP256R1: {
                return BRAINPOOLP256R1;
            }
            case BRAINPOOLP256T1: {
                return null;
            }
            case BRAINPOOLP320R1: {
                return null;
            }
            case BRAINPOOLP320T1: {
                return null;
            }
            case BRAINPOOLP384R1: {
                return BRAINPOOLP384R1;
            }
            case BRAINPOOLP384T1: {
                return null;
            }
            case BRAINPOOLP512R1: {
                return BRAINPOOLP512R1;
            }
            case BRAINPOOLP512T1: {
                return null;
            }
            case SECP112R1: {
                return null;
            }
            case SECP112R2: {
                return null;
            }
            case SECP128R1: {
                return null;
            }
            case SECP128R2: {
                return null;
            }
            case SECP160K1: {
                return SECP160K1;
            }
            case SECP160R1: {
                return SECP160R1;
            }
            case SECP160R2: {
                return SECP160R2;
            }
            case SECP192K1: {
                return SECP192K1;
            }
            case SECP192R1: {
                return SECP192R1;
            }
            case SECP224K1: {
                return SECP224K1;
            }
            case SECP224R1: {
                return SECP224R1;
            }
            case SECP256K1: {
                return SECP256K1;
            }
            case SECP256R1: {
                return SECP256R1;
            }
            case SECP384R1: {
                return SECP384R1;
            }
            case SECP521R1: {
                return SECP521R1;
            }
            case SECT113R1: {
                return null;
            }
            case SECT113R2: {
                return null;
            }
            case SECT131R1: {
                return null;
            }
            case SECT131R2: {
                return null;
            }
            case SECT163K1: {
                return SECT163K1;
            }
            case SECT163R1: {
                return SECT163R1;
            }
            case SECT163R2: {
                return SECT163R2;
            }
            case SECT193R1: {
                return SECT193R1;
            }
            case SECT193R2: {
                return SECT193R2;
            }
            case SECT233K1: {
                return SECT233K1;
            }
            case SECT233R1: {
                return SECT233R1;
            }
            case SECT239K1: {
                return SECT239K1;
            }
            case SECT283K1: {
                return SECT283K1;
            }
            case SECT283R1: {
                return SECT283R1;
            }
            case SECT409K1: {
                return SECT409K1;
            }
            case SECT409R1: {
                return SECT409R1;
            }
            case SECT571K1: {
                return SECT571K1;
            }
            case SECT571R1: {
                return SECT571R1;
            }
        }
        return null;
    }

    public static NamedGroup convert(GroupParameters<?> parameters) {
        for (NamedGroup group : NamedGroup.values()) {
            if (group.getGroupParameters() != parameters) continue;
            return group;
        }
        return null;
    }

    public byte[] getValue() {
        return this.value;
    }

    public GroupParameters<?> getGroupParameters() {
        return this.groupParameters;
    }

    public static NamedGroup getRandom(Random random) {
        NamedGroup c = null;
        while (c == null) {
            Object[] o = MAP.values().toArray();
            c = (NamedGroup)((Object)o[random.nextInt(o.length)]);
        }
        return c;
    }

    public static byte[] namedGroupsToByteArray(List<NamedGroup> groups) throws IOException {
        if (groups == null || groups.isEmpty()) {
            return new byte[0];
        }
        try (SilentByteArrayOutputStream bytes = new SilentByteArrayOutputStream();){
            for (NamedGroup i : groups) {
                bytes.write(i.getValue());
            }
            Object object = bytes.toByteArray();
            return object;
        }
    }

    public static List<NamedGroup> namedGroupsFromByteArray(byte[] sourceBytes) {
        if (sourceBytes == null || sourceBytes.length == 0) {
            return new ArrayList<NamedGroup>();
        }
        if (sourceBytes.length % 2 != 0) {
            throw new IllegalArgumentException("Failed to convert byte array. Source array size is not a multiple of destination type size.");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(sourceBytes);
        ArrayList<NamedGroup> groups = new ArrayList<NamedGroup>();
        while (inputStream.available() > 0) {
            try {
                byte[] groupBytes = inputStream.readNBytes(2);
                NamedGroup group = MAP.get(ByteBuffer.wrap(groupBytes));
                if (group != null) {
                    groups.add(group);
                    continue;
                }
                LOGGER.warn("Unknown named group: {}", (Object)groupBytes);
            }
            catch (IOException ex) {
                LOGGER.error("Could not read from ByteArrayInputStream", (Throwable)ex);
            }
        }
        return groups;
    }

    public boolean isShortWeierstrass() {
        if (this.isEcGroup()) {
            if (this.getGroupParameters() instanceof NamedEllipticCurveParameters) {
                return ((NamedEllipticCurveParameters)this.groupParameters).getEquationType() == EcCurveEquationType.SHORT_WEIERSTRASS;
            }
            throw new UnsupportedOperationException("Unknown group parameters: " + this.groupParameters.getClass().getSimpleName());
        }
        return false;
    }

    public boolean isMontgomery() {
        if (this.isEcGroup()) {
            if (this.getGroupParameters() instanceof NamedEllipticCurveParameters) {
                return ((NamedEllipticCurveParameters)this.groupParameters).getEquationType() == EcCurveEquationType.MONTGOMERY;
            }
            throw new UnsupportedOperationException("Unknown group parameters: " + this.groupParameters.getClass().getSimpleName());
        }
        return false;
    }

    @Deprecated
    public boolean isCurve() {
        return this.groupParameters != null && this.groupParameters.getGroup() != null;
    }

    public boolean isEcGroup() {
        return this.groupParameters != null && this.groupParameters.getGroup() instanceof EllipticCurve;
    }

    public boolean isDhGroup() {
        return this.groupParameters != null && this.groupParameters instanceof FfdhGroupParameters;
    }

    public boolean isGrease() {
        return this.name().contains("GREASE");
    }

    public static List<NamedGroup> getImplemented() {
        LinkedList<NamedGroup> list = new LinkedList<NamedGroup>();
        list.add(SECP160K1);
        list.add(SECP160R1);
        list.add(SECP160R2);
        list.add(SECP192K1);
        list.add(SECP192R1);
        list.add(SECP224K1);
        list.add(SECP224R1);
        list.add(SECP256K1);
        list.add(SECP256R1);
        list.add(SECP384R1);
        list.add(SECP521R1);
        list.add(SECT163K1);
        list.add(SECT163R1);
        list.add(SECT163R2);
        list.add(SECT193R1);
        list.add(SECT193R2);
        list.add(SECT233K1);
        list.add(SECT233R1);
        list.add(SECT239K1);
        list.add(SECT283K1);
        list.add(SECT283R1);
        list.add(SECT409K1);
        list.add(SECT409R1);
        list.add(SECT571K1);
        list.add(SECT571R1);
        list.add(ECDH_X25519);
        list.add(ECDH_X448);
        list.add(CURVE_SM2);
        list.add(BRAINPOOLP256R1);
        list.add(BRAINPOOLP384R1);
        list.add(BRAINPOOLP512R1);
        list.add(BRAINPOOLP256R1TLS13);
        list.add(BRAINPOOLP384R1TLS13);
        list.add(BRAINPOOLP512R1TLS13);
        list.add(FFDHE2048);
        list.add(FFDHE3072);
        list.add(FFDHE4096);
        list.add(FFDHE6144);
        list.add(FFDHE8192);
        return list;
    }

    public boolean isTls13() {
        return tls13Groups.contains((Object)this);
    }

    public boolean isGost() {
        return this.name().startsWith("GC");
    }

    static {
        LOGGER = LogManager.getLogger();
        tls13Groups = new HashSet<NamedGroup>(Arrays.asList(ECDH_X25519, ECDH_X448, FFDHE2048, FFDHE3072, FFDHE4096, FFDHE6144, FFDHE8192, SECP256R1, SECP384R1, SECP521R1, CURVE_SM2, MLKEM512, MLKEM768, MLKEM1024, BRAINPOOLP256R1TLS13, BRAINPOOLP384R1TLS13, BRAINPOOLP512R1TLS13, X25519_MLKEM768, SECP256R1_MLKEM768, SECP384R1_MLKEM1024));
        MAP = new HashMap<ByteBuffer, NamedGroup>();
        for (NamedGroup group : NamedGroup.values()) {
            MAP.put(ByteBuffer.wrap(group.value), group);
        }
    }
}

