/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.modifiablevariable.util.DataConverter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bouncycastle.util.Arrays;

public enum SSL2CipherSuite {
    SSL_CK_RC4_128_WITH_MD5(65664, 16, 0, 0),
    SSL_CK_RC4_128_EXPORT40_WITH_MD5(131200, 5, 11, 0),
    SSL_CK_RC2_128_CBC_WITH_MD5(196736, 16, 0, 8),
    SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5(262272, 5, 11, 8),
    SSL_CK_IDEA_128_CBC_WITH_MD5(327808, 16, 0, 8),
    SSL_CK_DES_64_CBC_WITH_MD5(393280, 8, 0, 8),
    SSL_CK_DES_192_EDE3_CBC_WITH_MD5(458944, 24, 0, 8),
    SSL_UNKNOWN_CIPHER(0x999999, 0, 0, 0);

    private static final int SSL2CipherSuiteLength = 3;
    private int value;
    private int secretKeyByteNumber;
    private int clearKeyByteNumber;
    private int blockSize;
    private static final Map<Integer, SSL2CipherSuite> MAP;

    private SSL2CipherSuite(int value, int secretKeyByteNumber, int clearKeyByteNumber, int blockSize) {
        this.value = value;
        this.secretKeyByteNumber = secretKeyByteNumber;
        this.clearKeyByteNumber = clearKeyByteNumber;
        this.blockSize = blockSize;
    }

    public static List<SSL2CipherSuite> getCipherSuites(byte[] values) {
        LinkedList<SSL2CipherSuite> cipherSuites = new LinkedList<SSL2CipherSuite>();
        for (int pointer = 0; pointer < values.length; pointer += 3) {
            byte[] suiteBytes = Arrays.copyOfRange((byte[])values, (int)pointer, (int)(pointer + 3));
            int suiteValue = DataConverter.bytesToInt((byte[])suiteBytes);
            cipherSuites.add(SSL2CipherSuite.getCipherSuite(suiteValue));
        }
        return cipherSuites;
    }

    public static SSL2CipherSuite getCipherSuite(int value) {
        SSL2CipherSuite cs = MAP.get(value);
        if (cs == null) {
            return SSL_UNKNOWN_CIPHER;
        }
        return cs;
    }

    public int getValue() {
        return this.value;
    }

    public byte[] getByteValue() {
        return DataConverter.intToBytes((int)this.value, (int)3);
    }

    public int getClearKeyByteNumber() {
        return this.clearKeyByteNumber;
    }

    public int getSecretKeyByteNumber() {
        return this.secretKeyByteNumber;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public boolean isWeak() {
        return this == SSL_CK_DES_64_CBC_WITH_MD5 || this == SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5 || this == SSL_CK_RC4_128_EXPORT40_WITH_MD5;
    }

    public boolean isExport() {
        return this == SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5 || this == SSL_CK_RC4_128_EXPORT40_WITH_MD5;
    }

    static {
        MAP = new HashMap<Integer, SSL2CipherSuite>();
        for (SSL2CipherSuite c : SSL2CipherSuite.values()) {
            MAP.put(c.value, c);
        }
    }
}

