/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.modifiablevariable.util.DataConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum SrtpProtectionProfile {
    SRTP_AES128_CM_HMAC_SHA1_80(new byte[]{0, 1}),
    SRTP_AES128_CM_HMAC_SHA1_32(new byte[]{0, 2}),
    SRTP_NULL_HMAC_SHA1_80(new byte[]{0, 5}),
    SRTP_NULL_HMAC_SHA1_32(new byte[]{0, 6}),
    SRTP_AEAD_AES_128_GCM(new byte[]{0, 7}),
    SRTP_AEAD_AES_256_GCM(new byte[]{0, 8}),
    DOUBLE_AEAD_AES_128_GCM_AEAD_AES_128_GCM(new byte[]{0, 9}),
    DOUBLE_AEAD_AES_256_GCM_AEAD_AES_256_GCM(new byte[]{0, 10}),
    SRTP_ARIA_128_CTR_HMAC_SHA1_80(new byte[]{0, 11}),
    SRTP_ARIA_128_CTR_HMAC_SHA1_32(new byte[]{0, 12}),
    SRTP_ARIA_256_CTR_HMAC_SHA1_80(new byte[]{0, 13}),
    SRTP_ARIA_256_CTR_HMAC_SHA1_32(new byte[]{0, 14}),
    SRTP_AEAD_ARIA_128_GCM(new byte[]{0, 15}),
    SRTP_AEAD_ARIA_256_GCM(new byte[]{0, 16});

    private final byte[] srtpProtectionProfiles;
    private static final Map<Integer, SrtpProtectionProfile> MAP;
    private static final Logger LOGGER;

    private SrtpProtectionProfile(byte[] value) {
        this.srtpProtectionProfiles = value;
    }

    public byte[] getByteValue() {
        return this.srtpProtectionProfiles;
    }

    public static SrtpProtectionProfile getProfileByType(byte[] value) {
        return MAP.get(DataConverter.bytesToInt((byte[])value));
    }

    public static List<SrtpProtectionProfile> getProfilesAsArrayList(byte[] value) {
        ArrayList<SrtpProtectionProfile> profileList = new ArrayList<SrtpProtectionProfile>();
        for (int i = 0; i < value.length; i += 2) {
            if (i + 1 < value.length) {
                profileList.add(SrtpProtectionProfile.getProfileByType(new byte[]{value[i], value[i + 1]}));
                continue;
            }
            LOGGER.warn("value cannot be converted into an SrtpProtectionProfile - not enough bytes left");
        }
        return profileList;
    }

    static {
        LOGGER = LogManager.getLogger();
        MAP = new HashMap<Integer, SrtpProtectionProfile>();
        for (SrtpProtectionProfile c : SrtpProtectionProfile.values()) {
            MAP.put(DataConverter.bytesToInt((byte[])c.srtpProtectionProfiles), c);
        }
    }
}

