/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants.hpke;

import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public enum HpkeAeadFunction {
    RESERVED(new byte[]{0, 0}, 0, 0, 0, CipherSuite.TLS_NULL_WITH_NULL_NULL),
    AES_128_GCM(new byte[]{0, 1}, 16, 12, 16, CipherSuite.TLS_AES_128_GCM_SHA256),
    AES_256_GCM(new byte[]{0, 2}, 32, 12, 16, CipherSuite.TLS_AES_256_GCM_SHA384),
    CHACHA20_POLY1305(new byte[]{0, 3}, 32, 12, 16, CipherSuite.TLS_CHACHA20_POLY1305_SHA256),
    EXPORT_ONLY(new byte[]{-1, -1}, 0, 0, 0, CipherSuite.TLS_NULL_WITH_NULL_NULL);

    private static final Map<BigInteger, HpkeAeadFunction> MAP;
    private final byte[] byteValue;
    private final int keyLength;
    private final int nonceLength;
    private final int tagLength;
    private final CipherSuite cipherSuite;

    private HpkeAeadFunction(byte[] byteValue, int keyLength, int nonceLength, int tagLength, CipherSuite cipherSuite) {
        this.byteValue = byteValue;
        this.keyLength = keyLength;
        this.nonceLength = nonceLength;
        this.tagLength = tagLength;
        this.cipherSuite = cipherSuite;
    }

    public byte[] getByteValue() {
        return this.byteValue;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public int getNonceLength() {
        return this.nonceLength;
    }

    public int getTagLength() {
        return this.tagLength;
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public static HpkeAeadFunction getEnumByByte(byte[] versionBytes) {
        if (versionBytes == null) {
            return RESERVED;
        }
        BigInteger hashMapKey = new BigInteger(versionBytes);
        return MAP.get(hashMapKey);
    }

    static {
        MAP = new HashMap<BigInteger, HpkeAeadFunction>();
        for (HpkeAeadFunction version : HpkeAeadFunction.values()) {
            byte[] versionBytes = version.getByteValue();
            if (versionBytes == null) continue;
            BigInteger hashMapKey = new BigInteger(versionBytes);
            MAP.put(hashMapKey, version);
        }
    }
}

