/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants.hpke;

import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public enum HpkeKeyDerivationFunction {
    RESERVED(new byte[]{0, 0}, 0, HKDFAlgorithm.TLS_HKDF_SHA256),
    HKDF_SHA256(new byte[]{0, 1}, 32, HKDFAlgorithm.TLS_HKDF_SHA256),
    HKDF_SHA384(new byte[]{0, 2}, 48, HKDFAlgorithm.TLS_HKDF_SHA384),
    HKDF_SHA512(new byte[]{0, 3}, 64, HKDFAlgorithm.TLS_HKDF_SHA512);

    private static final Map<BigInteger, HpkeKeyDerivationFunction> MAP;
    private final byte[] byteValue;
    private final int hashLength;
    private final HKDFAlgorithm hkdfAlgorithm;

    private HpkeKeyDerivationFunction(byte[] byteValue, int hashLength, HKDFAlgorithm hkdfAlgorithm) {
        this.byteValue = byteValue;
        this.hashLength = hashLength;
        this.hkdfAlgorithm = hkdfAlgorithm;
    }

    public byte[] getByteValue() {
        return this.byteValue;
    }

    public int getHashLength() {
        return this.hashLength;
    }

    public HKDFAlgorithm getHkdfAlgorithm() {
        return this.hkdfAlgorithm;
    }

    public static HpkeKeyDerivationFunction getEnumByByte(byte[] versionBytes) {
        if (versionBytes == null) {
            return RESERVED;
        }
        BigInteger hashMapKey = new BigInteger(versionBytes);
        return MAP.get(hashMapKey);
    }

    static {
        MAP = new HashMap<BigInteger, HpkeKeyDerivationFunction>();
        for (HpkeKeyDerivationFunction version : HpkeKeyDerivationFunction.values()) {
            byte[] versionBytes = version.getByteValue();
            if (versionBytes == null) continue;
            BigInteger hashMapKey = new BigInteger(versionBytes);
            MAP.put(hashMapKey, version);
        }
    }
}

