/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants.hpke;

import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public enum HpkeKeyEncapsulationMechanism {
    RESERVED(new byte[]{0, 0}, 0, 0, 0, 0, true, null),
    DHKEM_P256_HKDF_SHA256(new byte[]{0, 16}, 32, 65, 65, 32, true, NamedGroup.SECP256R1),
    DHKEM_P384_HKDF_SHA384(new byte[]{0, 17}, 48, 97, 97, 48, true, NamedGroup.SECP384R1),
    DHKEM_P521_HKDF_SHA512(new byte[]{0, 18}, 64, 133, 133, 66, true, NamedGroup.SECP521R1),
    DHKEM_X25519_HKDF_SHA256(new byte[]{0, 32}, 32, 32, 32, 32, true, NamedGroup.ECDH_X25519),
    DHKEM_X448_HKDF_SHA521(new byte[]{0, 33}, 64, 56, 56, 56, true, NamedGroup.ECDH_X448);

    private static final Map<BigInteger, HpkeKeyEncapsulationMechanism> MAP;
    private final byte[] byteValue;
    private final int secretLength;
    private final int encryptionLength;
    private final int publicKeyLength;
    private final int secretKeyLength;
    private final boolean providesAuthentication;
    private final NamedGroup namedGroup;

    private HpkeKeyEncapsulationMechanism(byte[] byteValue, int secretLength, int encryptionLength, int publicKeyLength, int secretKeyLength, boolean providesAuthentication, NamedGroup namedGroup) {
        this.byteValue = byteValue;
        this.secretLength = secretLength;
        this.encryptionLength = encryptionLength;
        this.publicKeyLength = publicKeyLength;
        this.secretKeyLength = secretKeyLength;
        this.providesAuthentication = providesAuthentication;
        this.namedGroup = namedGroup;
    }

    public byte[] getByteValue() {
        return this.byteValue;
    }

    public int getSecretLength() {
        return this.secretLength;
    }

    public int getEncryptionLength() {
        return this.encryptionLength;
    }

    public int getPublicKeyLength() {
        return this.publicKeyLength;
    }

    public int getSecretKeyLength() {
        return this.secretKeyLength;
    }

    public boolean isProvidesAuthentication() {
        return this.providesAuthentication;
    }

    public NamedGroup getNamedGroup() {
        return this.namedGroup;
    }

    public static HpkeKeyEncapsulationMechanism getEnumByByte(byte[] versionBytes) {
        if (versionBytes == null) {
            return RESERVED;
        }
        BigInteger hashMapKey = new BigInteger(versionBytes);
        return MAP.get(hashMapKey);
    }

    static {
        MAP = new HashMap<BigInteger, HpkeKeyEncapsulationMechanism>();
        for (HpkeKeyEncapsulationMechanism version : HpkeKeyEncapsulationMechanism.values()) {
            byte[] versionBytes = version.getByteValue();
            if (versionBytes == null) continue;
            BigInteger hashMapKey = new BigInteger(versionBytes);
            MAP.put(hashMapKey, version);
        }
    }
}

