/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.MacAlgorithm;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HMAC {
    private static final Logger LOGGER = LogManager.getLogger();
    private byte[] opad;
    private byte[] ipad;
    private byte[] secret;
    private MacAlgorithm macAlgorithm;
    private MessageDigest digest;

    public HMAC(MacAlgorithm macAlgorithm) throws NoSuchAlgorithmException {
        this.macAlgorithm = macAlgorithm;
        switch (macAlgorithm) {
            case HMAC_SHA1: {
                this.digest = MessageDigest.getInstance("SHA-1");
                break;
            }
            case HMAC_MD5: {
                this.digest = MessageDigest.getInstance("MD5");
                break;
            }
            case HMAC_SHA256: {
                this.digest = MessageDigest.getInstance("SHA-256");
                break;
            }
            case HMAC_SHA384: {
                this.digest = MessageDigest.getInstance("SHA-384");
                break;
            }
            case HMAC_GOSTR3411: {
                this.digest = MessageDigest.getInstance("GOST3411");
                break;
            }
            case HMAC_GOSTR3411_2012_256: {
                this.digest = MessageDigest.getInstance("GOST3411-2012-256");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Hash algorithm is not supported");
            }
        }
    }

    public void init(byte[] secret) throws NoSuchAlgorithmException {
        if (secret == null) {
            LOGGER.warn("Secret is null! Continuing to init hmac with a secret set to zero bytes...");
            secret = new byte[]{};
        }
        switch (this.macAlgorithm) {
            case HMAC_SHA1: 
            case HMAC_MD5: 
            case HMAC_SHA256: 
            case HMAC_GOSTR3411_2012_256: {
                this.secret = this.padding(secret, 64, (byte)0);
                this.opad = this.padding(new byte[0], 64, (byte)92);
                this.ipad = this.padding(new byte[0], 64, (byte)54);
                break;
            }
            case HMAC_SHA384: {
                this.secret = this.padding(secret, 128, (byte)0);
                this.opad = this.padding(new byte[0], 128, (byte)92);
                this.ipad = this.padding(new byte[0], 128, (byte)54);
                break;
            }
            case HMAC_GOSTR3411: {
                this.secret = this.padding(secret, 32, (byte)0);
                this.opad = this.padding(new byte[0], 32, (byte)92);
                this.ipad = this.padding(new byte[0], 32, (byte)54);
                break;
            }
            default: {
                LOGGER.warn("Undefined MAC Algorithm");
                this.secret = secret;
                this.opad = new byte[0];
                this.ipad = new byte[0];
            }
        }
    }

    public byte[] doFinal(byte[] data) throws NoSuchAlgorithmException {
        byte[] hash = this.digest.digest(DataConverter.concatenate((byte[][])new byte[][]{this.xorBytes(this.secret, this.ipad), data}));
        return this.digest.digest(DataConverter.concatenate((byte[][])new byte[][]{this.xorBytes(this.secret, this.opad), hash}));
    }

    private byte[] padding(byte[] bytes, int length, byte pad) throws NoSuchAlgorithmException {
        if (bytes.length < length) {
            int i;
            byte[] bytesPadded = new byte[length];
            for (i = 0; i < bytes.length; ++i) {
                bytesPadded[i] = bytes[i];
            }
            for (i = bytes.length; i < length; ++i) {
                bytesPadded[i] = pad;
            }
            return bytesPadded;
        }
        if (bytes.length == length) {
            return bytes;
        }
        byte[] hash = this.hash(bytes);
        return this.padding(hash, length, pad);
    }

    private byte[] xorBytes(byte[] a1, byte[] a2) {
        byte[] a3 = new byte[a1.length];
        for (int i = 0; i < a1.length; ++i) {
            a3[i] = (byte)(a1[i] ^ a2[i]);
        }
        return a3;
    }

    private byte[] hash(byte[] bytes) throws NoSuchAlgorithmException {
        return this.digest.digest(bytes);
    }
}

