/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.GroupParameters;
import de.rub.nds.protocol.constants.PointFormat;
import de.rub.nds.protocol.crypto.CyclicGroup;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.ec.PointFormatter;
import de.rub.nds.protocol.crypto.ec.RFC7748Curve;
import de.rub.nds.protocol.crypto.ffdh.FfdhGroup;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeyShareCalculator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LoadingCache<Triple<NamedGroup, BigInteger, ECPointFormat>, byte[]> publicKeyCache = CacheBuilder.newBuilder().maximumSize(256L).expireAfterAccess(10L, TimeUnit.MINUTES).build(CacheLoader.from(KeyShareCalculator::createPublicKey));

    public static byte[] createPublicKey(NamedGroup namedGroup, BigInteger privateKey, ECPointFormat pointFormat) {
        return (byte[])publicKeyCache.getUnchecked((Object)Triple.of((Object)((Object)namedGroup), (Object)privateKey, (Object)((Object)pointFormat)));
    }

    private static byte[] createPublicKey(Triple<NamedGroup, BigInteger, ECPointFormat> parameters) {
        NamedGroup namedGroup = (NamedGroup)((Object)parameters.getLeft());
        BigInteger privateKey = (BigInteger)parameters.getMiddle();
        ECPointFormat pointFormat = (ECPointFormat)((Object)parameters.getRight());
        if (namedGroup.isGrease()) {
            return new byte[0];
        }
        CyclicGroup group = namedGroup.getGroupParameters().getGroup();
        if (namedGroup.isEcGroup()) {
            if (namedGroup.isShortWeierstrass()) {
                Point publicKey = (Point)group.nTimesGroupOperationOnGenerator(privateKey);
                return PointFormatter.formatToByteArray(namedGroup.getGroupParameters(), (Point)publicKey, (PointFormat)pointFormat.getFormat());
            }
            RFC7748Curve rfcCurve = (RFC7748Curve)group;
            return rfcCurve.computePublicKey(privateKey);
        }
        if (namedGroup.isDhGroup()) {
            BigInteger publicKey = (BigInteger)group.nTimesGroupOperationOnGenerator(privateKey);
            return DataConverter.bigIntegerToNullPaddedByteArray((BigInteger)publicKey, (int)((FfdhGroup)group).getParameters().getElementSizeBytes());
        }
        LOGGER.warn("Cannot create Public Key for group {}", (Object)namedGroup.name());
        return new byte[0];
    }

    public static byte[] computeSharedSecret(NamedGroup group, BigInteger privateKey, byte[] publicKey) {
        if (group.isGrease()) {
            return new byte[0];
        }
        if (group.isDhGroup()) {
            return KeyShareCalculator.computeDhSharedSecret(group, privateKey, new BigInteger(1, publicKey));
        }
        if (group.isEcGroup()) {
            Point point = PointFormatter.formatFromByteArray(group.getGroupParameters(), (byte[])publicKey);
            return KeyShareCalculator.computeEcSharedSecret(group, privateKey, point);
        }
        LOGGER.warn("Not sure how to compute shared secret for with: {} - using new byte[0] instead.", (Object)group.name());
        return new byte[0];
    }

    public static byte[] computeDhSharedSecret(NamedGroup group, BigInteger privateKey, BigInteger publicKey) {
        if (!group.isDhGroup()) {
            throw new IllegalArgumentException("Cannot compute dh shared secret for non ffdhe group");
        }
        CyclicGroup cyclicGroup = group.getGroupParameters().getGroup();
        if (!(cyclicGroup instanceof FfdhGroup)) {
            throw new IllegalArgumentException("Cannot compute dh shared secret for non ffdhe group");
        }
        BigInteger sharedSecret = ((FfdhGroup)cyclicGroup).nTimesGroupOperation(publicKey, privateKey);
        return DataConverter.bigIntegerToNullPaddedByteArray((BigInteger)sharedSecret, (int)group.getGroupParameters().getElementSizeBytes());
    }

    public static byte[] computeEcSharedSecret(NamedGroup namedGroup, BigInteger privateKey, Point publicKey) {
        if (!(namedGroup.getGroupParameters().getGroup() instanceof EllipticCurve)) {
            throw new IllegalArgumentException("Cannot compute ec shared secret for non ec group");
        }
        GroupParameters<?> parameters = namedGroup.getGroupParameters();
        EllipticCurve curve = (EllipticCurve)parameters.getGroup();
        if (curve instanceof RFC7748Curve) {
            RFC7748Curve rfcCurve = (RFC7748Curve)curve;
            return rfcCurve.computeSharedSecretFromDecodedPoint(privateKey, publicKey);
        }
        Point sharedPoint = curve.nTimesGroupOperation(publicKey, privateKey);
        int elementLength = parameters.getElementSizeBytes();
        return DataConverter.bigIntegerToNullPaddedByteArray((BigInteger)sharedPoint.getFieldX().getData(), (int)elementLength);
    }
}

