/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto;

import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.constants.MacAlgorithm;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.Arrays;

public class SSLUtils {
    private static final MessageFormat ILLEGAL_MAC_ALGORITHM = new MessageFormat("{0}, is not a valid MacAlgorithm for SSLv3, only MD5 and SHA-1 are available.");
    private static final byte[] MD5_PAD1 = DataConverter.hexStringToByteArray((String)StringUtils.repeat((String)"36", (int)48));
    private static final byte[] MD5_PAD2 = DataConverter.hexStringToByteArray((String)StringUtils.repeat((String)"5c", (int)48));
    private static final byte[] SHA_PAD1 = DataConverter.hexStringToByteArray((String)StringUtils.repeat((String)"36", (int)40));
    private static final byte[] SHA_PAD2 = DataConverter.hexStringToByteArray((String)StringUtils.repeat((String)"5c", (int)40));
    private static final byte[][] SSL3_CONST = SSLUtils.genSSL3Const();

    private static byte[][] genSSL3Const() {
        int n = 10;
        byte[][] arr = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] b = new byte[i + 1];
            Arrays.fill((byte[])b, (byte)((byte)(65 + i)));
            arr[i] = b;
        }
        return arr;
    }

    public static byte[] calculateMasterSecretSSL3(byte[] preMasterSecret, byte[] random) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            int md5Size = md5.getDigestLength();
            byte[] shaTmp = new byte[sha1.getDigestLength()];
            byte[] rval = new byte[md5Size * 3];
            int pos = 0;
            for (int i = 0; i < 3; ++i) {
                byte[] ssl3Const = SSL3_CONST[i];
                sha1.update(ssl3Const, 0, ssl3Const.length);
                sha1.update(preMasterSecret, 0, preMasterSecret.length);
                sha1.update(random, 0, random.length);
                sha1.digest(shaTmp, 0, shaTmp.length);
                md5.update(preMasterSecret, 0, preMasterSecret.length);
                md5.update(shaTmp, 0, shaTmp.length);
                md5.digest(rval, pos, md5.getDigestLength());
                pos += md5Size;
            }
            return rval;
        }
        catch (DigestException | NoSuchAlgorithmException e) {
            throw new CryptoException("Either MD5 or SHA-1 algorithm is not provided by the Execution-Environment, check your providers.", (Throwable)e);
        }
    }

    public static byte[] calculateKeyBlockSSL3(byte[] masterSecret, byte[] random, int size) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            int md5Size = md5.getDigestLength();
            byte[] shaTmp = new byte[sha1.getDigestLength()];
            byte[] tmp = new byte[size + md5Size];
            int i = 0;
            int pos = 0;
            while (pos < size) {
                if (SSL3_CONST.length <= i) {
                    i = 0;
                }
                byte[] ssl3Const = SSL3_CONST[i];
                sha1.update(ssl3Const, 0, ssl3Const.length);
                sha1.update(masterSecret, 0, masterSecret.length);
                sha1.update(random, 0, random.length);
                sha1.digest(shaTmp, 0, shaTmp.length);
                md5.update(masterSecret, 0, masterSecret.length);
                md5.update(shaTmp, 0, shaTmp.length);
                md5.digest(tmp, pos, tmp.length - pos);
                pos += md5Size;
                ++i;
            }
            return Arrays.copyOfRange((byte[])tmp, (int)0, (int)size);
        }
        catch (DigestException | NoSuchAlgorithmException e) {
            throw new CryptoException("Either MD5 or SHA-1 algorithm is not provided by the Execution-Environment, check your providers.", (Throwable)e);
        }
    }

    public static byte[] getSenderConstant(Chooser chooser) {
        return SSLUtils.getSenderConstant(chooser.getConnectionEndType());
    }

    public static byte[] getSenderConstant(ConnectionEndType connectionEndType) {
        if (null == connectionEndType) {
            throw new IllegalArgumentException("The ConnectionEnd should be either of Type Client or Server but it is null");
        }
        switch (connectionEndType) {
            case SERVER: {
                return Sender.SERVER.getValue();
            }
            case CLIENT: {
                return Sender.CLIENT.getValue();
            }
        }
        throw new IllegalArgumentException("The ConnectionEnd should be either of Type Client or Server but it is " + String.valueOf(connectionEndType));
    }

    public static byte[] getPad1(MacAlgorithm macAlgorithm) {
        if (null == macAlgorithm) {
            throw new IllegalArgumentException("MAC Algorithm must not be null");
        }
        switch (macAlgorithm) {
            case SSLMAC_MD5: {
                return (byte[])MD5_PAD1.clone();
            }
            case SSLMAC_SHA1: {
                return (byte[])SHA_PAD1.clone();
            }
        }
        throw new CryptoException(ILLEGAL_MAC_ALGORITHM.format(macAlgorithm.getJavaName()));
    }

    public static byte[] getPad2(MacAlgorithm macAlgorithm) {
        if (null == macAlgorithm) {
            throw new IllegalArgumentException("MAC Algorithm must not be null");
        }
        switch (macAlgorithm) {
            case SSLMAC_MD5: {
                return (byte[])MD5_PAD2.clone();
            }
            case SSLMAC_SHA1: {
                return (byte[])SHA_PAD2.clone();
            }
        }
        throw new CryptoException(ILLEGAL_MAC_ALGORITHM.format(macAlgorithm.getJavaName()));
    }

    private static String getHashAlgorithm(MacAlgorithm macAlgorithm) {
        if (null == macAlgorithm) {
            throw new IllegalArgumentException("MAC Algorithm must not be null");
        }
        switch (macAlgorithm) {
            case SSLMAC_MD5: {
                return "MD5";
            }
            case SSLMAC_SHA1: {
                return "SHA-1";
            }
        }
        throw new CryptoException(ILLEGAL_MAC_ALGORITHM.format(macAlgorithm.getJavaName()));
    }

    public static byte[] calculateSSLMac(byte[] input, byte[] macWriteSecret, MacAlgorithm macAlgorithm) {
        byte[] pad1 = SSLUtils.getPad1(macAlgorithm);
        byte[] pad2 = SSLUtils.getPad2(macAlgorithm);
        try {
            String hashName = SSLUtils.getHashAlgorithm(macAlgorithm);
            MessageDigest hashFunction = MessageDigest.getInstance(hashName);
            byte[] innerInput = DataConverter.concatenate((byte[][])new byte[][]{macWriteSecret, pad1, input});
            byte[] innerHash = hashFunction.digest(innerInput);
            byte[] outerInput = DataConverter.concatenate((byte[][])new byte[][]{macWriteSecret, pad2, innerHash});
            byte[] outerHash = hashFunction.digest(outerInput);
            return outerHash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(ILLEGAL_MAC_ALGORITHM.format(macAlgorithm.getJavaName()));
        }
    }

    public static byte[] calculateSSLCertificateVerifySignature(byte[] handshakeMessages, byte[] masterSecret) {
        return SSLUtils.calculateSSLMd5SHASignature(handshakeMessages, masterSecret);
    }

    public static byte[] calculateFinishedData(byte[] handshakeMessages, byte[] masterSecret, ConnectionEndType connectionEndType) {
        byte[] input = DataConverter.concatenate((byte[][])new byte[][]{handshakeMessages, SSLUtils.getSenderConstant(connectionEndType)});
        return SSLUtils.calculateSSLMd5SHASignature(input, masterSecret);
    }

    private static byte[] calculateSSLMd5SHASignature(byte[] input, byte[] masterSecret) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            byte[] innerMD5Content = DataConverter.concatenate((byte[][])new byte[][]{input, masterSecret, MD5_PAD1});
            byte[] innerSHAContent = DataConverter.concatenate((byte[][])new byte[][]{input, masterSecret, SHA_PAD1});
            byte[] innerMD5 = md5.digest(innerMD5Content);
            byte[] innerSHA = sha.digest(innerSHAContent);
            byte[] outerMD5Content = DataConverter.concatenate((byte[][])new byte[][]{masterSecret, MD5_PAD2, innerMD5});
            byte[] outerSHAContent = DataConverter.concatenate((byte[][])new byte[][]{masterSecret, SHA_PAD2, innerSHA});
            byte[] outerMD5 = md5.digest(outerMD5Content);
            byte[] outerSHA = sha.digest(outerSHAContent);
            return DataConverter.concatenate((byte[][])new byte[][]{outerMD5, outerSHA});
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException("Either MD5 or SHA-1 algorithm is not provided by the Execution-Environment, check your providers.", (Throwable)e);
        }
    }

    private SSLUtils() {
    }

    private static enum Sender {
        CLIENT("434C4E54"),
        SERVER("53525652");

        private final byte[] value;

        private Sender(String hex) {
            this.value = DataConverter.hexStringToByteArray((String)hex);
        }

        public byte[] getValue() {
            return (byte[])this.value.clone();
        }
    }
}

