/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.cipher;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.constants.BulkCipherAlgorithm;
import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.cipher.BaseCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class JavaCipher
extends BaseCipher {
    private static final Logger LOGGER = LogManager.getLogger();
    private final CipherAlgorithm algorithm;
    private byte[] iv;
    private byte[] key;
    private boolean keepCipherState;
    private Cipher cipher = null;

    public JavaCipher(CipherAlgorithm algorithm, byte[] key, boolean keepCipherState) {
        this.algorithm = algorithm;
        this.key = key;
        this.keepCipherState = keepCipherState;
    }

    @Override
    public int getBlocksize() {
        return this.algorithm.getBlocksize();
    }

    @Override
    public byte[] encrypt(byte[] iv, byte[] someBytes) throws CryptoException {
        IvParameterSpec encryptIv = new IvParameterSpec(iv);
        try {
            this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
            String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
            this.cipher.init(1, (Key)new SecretKeySpec(this.key, keySpecAlgorithm), encryptIv);
            byte[] result = this.cipher.doFinal(someBytes);
            this.iv = this.cipher.getIV();
            return result;
        }
        catch (IllegalArgumentException | IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not initialize JavaCipher. Did you forget to add BouncyCastleProvider?", (Throwable)ex);
        }
    }

    @Override
    public byte[] encrypt(byte[] someBytes) throws CryptoException {
        try {
            if (this.cipher == null) {
                this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
                String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
                this.cipher.init(1, new SecretKeySpec(this.key, keySpecAlgorithm));
            }
            if (this.keepCipherState) {
                return this.cipher.update(someBytes);
            }
            return this.cipher.doFinal(someBytes);
        }
        catch (IllegalArgumentException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not encrypt data with: " + this.algorithm.getJavaName(), (Throwable)ex);
        }
    }

    @Override
    public byte[] encrypt(byte[] iv, int tagLength, byte[] someBytes) throws CryptoException {
        GCMParameterSpec encryptIv = new GCMParameterSpec(tagLength, iv);
        try {
            this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
            String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
            this.cipher.init(1, (Key)new SecretKeySpec(this.key, keySpecAlgorithm), encryptIv);
            byte[] result = this.cipher.doFinal(someBytes);
            this.iv = this.cipher.getIV();
            return result;
        }
        catch (IllegalArgumentException | IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not encrypt data with " + this.algorithm.getJavaName(), (Throwable)ex);
        }
    }

    @Override
    public byte[] encrypt(byte[] iv, int tagLength, byte[] additionAuthenticatedData, byte[] someBytes) throws CryptoException {
        GCMParameterSpec encryptIv = new GCMParameterSpec(tagLength, iv);
        try {
            this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
            String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
            this.cipher.init(1, (Key)new SecretKeySpec(this.key, keySpecAlgorithm), encryptIv);
            this.cipher.updateAAD(additionAuthenticatedData);
            byte[] result = this.cipher.doFinal(someBytes);
            this.iv = this.cipher.getIV();
            return result;
        }
        catch (IllegalArgumentException | IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not encrypt data with " + this.algorithm.getJavaName(), (Throwable)ex);
        }
    }

    @Override
    public byte[] getIv() {
        return this.iv;
    }

    @Override
    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    @Override
    public byte[] decrypt(byte[] iv, byte[] someBytes) throws CryptoException {
        IvParameterSpec decryptIv = new IvParameterSpec(iv);
        try {
            this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
            String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
            this.cipher.init(2, (Key)new SecretKeySpec(this.key, keySpecAlgorithm), decryptIv);
            byte[] result = this.cipher.doFinal(someBytes);
            if (result.length >= this.getBlocksize()) {
                this.iv = new byte[this.getBlocksize()];
                System.arraycopy(someBytes, someBytes.length - this.getBlocksize(), this.iv, 0, this.getBlocksize());
            }
            return result;
        }
        catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not decrypt data", (Throwable)ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] someBytes) throws CryptoException {
        try {
            if (this.cipher == null) {
                this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
                String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
                this.cipher.init(2, new SecretKeySpec(this.key, keySpecAlgorithm));
            }
            if (this.keepCipherState) {
                return this.cipher.update(someBytes);
            }
            return this.cipher.doFinal(someBytes);
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not decrypt data", (Throwable)ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] iv, int tagLength, byte[] someBytes) throws CryptoException {
        GCMParameterSpec decryptIv = new GCMParameterSpec(tagLength, iv);
        try {
            this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
            String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
            this.cipher.init(2, (Key)new SecretKeySpec(this.key, keySpecAlgorithm), decryptIv);
            byte[] result = this.cipher.doFinal(someBytes);
            if (result.length >= this.getBlocksize()) {
                this.iv = new byte[this.getBlocksize()];
                System.arraycopy(someBytes, someBytes.length - this.getBlocksize(), this.iv, 0, this.getBlocksize());
            }
            return result;
        }
        catch (IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not decrypt data", (Throwable)ex);
        }
    }

    @Override
    public byte[] decrypt(byte[] iv, int tagLength, byte[] additionalAuthenticatedData, byte[] cipherText) throws CryptoException {
        GCMParameterSpec decryptIv = new GCMParameterSpec(tagLength, iv);
        try {
            this.cipher = Cipher.getInstance(this.algorithm.getJavaName());
            String keySpecAlgorithm = BulkCipherAlgorithm.getBulkCipherAlgorithm(this.algorithm).getJavaName();
            this.cipher.init(2, (Key)new SecretKeySpec(this.key, keySpecAlgorithm), decryptIv);
            this.cipher.updateAAD(additionalAuthenticatedData);
            byte[] result = this.cipher.doFinal(cipherText);
            if (result.length >= this.getBlocksize()) {
                this.iv = new byte[this.getBlocksize()];
                System.arraycopy(cipherText, cipherText.length - this.getBlocksize(), this.iv, 0, this.getBlocksize());
            }
            return result;
        }
        catch (IllegalArgumentException | IllegalStateException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Could not decrypt data", (Throwable)ex);
        }
    }

    @Override
    public byte[] getDtls13Mask(byte[] key, byte[] ciphertext) throws CryptoException {
        if (!this.algorithm.getJavaName().startsWith("AES")) {
            LOGGER.warn("Selected cipher does not support DTLS 1.3 masking. Returning empty mask!");
            return new byte[0];
        }
        if (ciphertext.length < 16) {
            LOGGER.warn("The ciphertext is too short. Padding it to the required length with zero bytes.");
        }
        byte[] toEncrypt = Arrays.copyOf(ciphertext, 16);
        try {
            Cipher recordNumberCipher = Cipher.getInstance("AES/ECB/NoPadding");
            recordNumberCipher.init(1, new SecretKeySpec(key, "AES"));
            return recordNumberCipher.doFinal(toEncrypt);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new CryptoException("Error getting record number mask using AES: ", (Throwable)ex);
        }
    }
}

