/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.gost;

import de.rub.nds.tlsattacker.core.constants.CipherAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.cipher.GOST28147Cipher;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithSBox;
import org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import org.bouncycastle.util.Memoable;

public class GOST28147Mac
implements Mac,
Memoable {
    private int blockSize = 8;
    private int macSize = 4;
    private int bufOff;
    private int processedBytes;
    private byte[] buf;
    private byte[] mac;
    private boolean firstStep = true;
    private byte[] key;
    private int[] workingKey = null;
    private byte[] macIV = null;
    private final Cipher meshCipher;
    private byte[] sbox = new byte[]{9, 6, 3, 2, 8, 11, 1, 7, 10, 4, 14, 15, 12, 0, 13, 5, 3, 7, 14, 9, 8, 10, 15, 0, 5, 2, 6, 12, 11, 4, 13, 1, 14, 4, 6, 2, 11, 3, 13, 8, 12, 15, 5, 10, 0, 7, 1, 9, 14, 7, 10, 12, 13, 1, 3, 9, 0, 2, 11, 4, 15, 8, 5, 6, 11, 5, 1, 9, 8, 13, 15, 0, 14, 4, 2, 3, 12, 7, 10, 6, 3, 10, 13, 12, 1, 2, 0, 11, 7, 5, 9, 4, 8, 15, 14, 6, 1, 13, 2, 9, 7, 10, 6, 0, 8, 12, 4, 5, 15, 3, 11, 14, 11, 10, 15, 5, 0, 12, 14, 8, 6, 2, 3, 9, 1, 7, 13, 4};

    public GOST28147Mac() {
        this.mac = new byte[this.blockSize];
        this.buf = new byte[this.blockSize];
        this.key = new byte[32];
        try {
            this.meshCipher = Cipher.getInstance(CipherAlgorithm.GOST_28147_CNT_IMIT.getJavaName());
        }
        catch (GeneralSecurityException e) {
            throw new UnsupportedOperationException("Could not initialize mesh cipher!");
        }
    }

    private GOST28147Mac(GOST28147Mac mac) {
        this();
        this.reset(mac);
    }

    private int[] generateWorkingKey(byte[] userKey) {
        if (userKey.length != 32) {
            throw new IllegalArgumentException("Key length invalid. Key needs to be 32 byte - 256 bit!!!");
        }
        int[] key = new int[8];
        for (int i = 0; i != 8; ++i) {
            key[i] = this.bytesToInt(userKey, i * 4);
        }
        return key;
    }

    public void init(CipherParameters params) throws IllegalArgumentException {
        ParametersWithIV param;
        this.reset();
        this.buf = new byte[this.blockSize];
        this.macIV = null;
        if (params instanceof ParametersWithIV) {
            param = (ParametersWithIV)params;
            System.arraycopy(param.getIV(), 0, this.mac, 0, this.mac.length);
            this.macIV = param.getIV();
            params = param.getParameters();
        }
        if (params instanceof ParametersWithSBox) {
            param = (ParametersWithSBox)params;
            System.arraycopy(param.getSBox(), 0, this.sbox, 0, param.getSBox().length);
            params = param.getParameters();
        }
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to GOST28147 init - " + params.getClass().getName());
        }
        this.key = ((KeyParameter)params).getKey();
        this.workingKey = this.generateWorkingKey(this.key);
    }

    public String getAlgorithmName() {
        return "GOST28147Mac";
    }

    public int getMacSize() {
        return this.macSize;
    }

    private int gost28147_mainStep(int n1, int key) {
        int cm = key + n1;
        int om = this.sbox[0 + (cm >> 0 & 0xF)] << 0;
        om += this.sbox[16 + (cm >> 4 & 0xF)] << 4;
        om += this.sbox[32 + (cm >> 8 & 0xF)] << 8;
        om += this.sbox[48 + (cm >> 12 & 0xF)] << 12;
        om += this.sbox[64 + (cm >> 16 & 0xF)] << 16;
        om += this.sbox[80 + (cm >> 20 & 0xF)] << 20;
        om += this.sbox[96 + (cm >> 24 & 0xF)] << 24;
        return (om += this.sbox[112 + (cm >> 28 & 0xF)] << 28) << 11 | om >>> 21;
    }

    private void gost28147MacFunc(byte[] in, byte[] out) {
        if (this.processedBytes == 1024) {
            this.processedBytes = 0;
            try {
                SecretKeySpec spec = new SecretKeySpec(this.key, this.meshCipher.getAlgorithm());
                this.meshCipher.init(2, (Key)spec, (AlgorithmParameterSpec)new GOST28147ParameterSpec(this.sbox));
                this.key = this.meshCipher.doFinal(GOST28147Cipher.getC());
                this.workingKey = this.generateWorkingKey(this.key);
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException("Could not mesh key!");
            }
        }
        this.processedBytes += 8;
        int n1 = this.bytesToInt(in, 0);
        int n2 = this.bytesToInt(in, 4);
        for (int k = 0; k < 2; ++k) {
            for (int j = 0; j < 8; ++j) {
                int tmp = n1;
                n1 = n2 ^ this.gost28147_mainStep(n1, this.workingKey[j]);
                n2 = tmp;
            }
        }
        this.intToBytes(n1, out, 0);
        this.intToBytes(n2, out, 4);
    }

    private int bytesToInt(byte[] in, int inOff) {
        return (in[inOff + 3] << 24 & 0xFF000000) + (in[inOff + 2] << 16 & 0xFF0000) + (in[inOff + 1] << 8 & 0xFF00) + (in[inOff] & 0xFF);
    }

    private void intToBytes(int num, byte[] out, int outOff) {
        out[outOff + 3] = (byte)(num >>> 24);
        out[outOff + 2] = (byte)(num >>> 16);
        out[outOff + 1] = (byte)(num >>> 8);
        out[outOff] = (byte)num;
    }

    private byte[] cm5Func(byte[] buf, int bufOff, byte[] mac) {
        byte[] sum = new byte[buf.length - bufOff];
        System.arraycopy(buf, bufOff, sum, 0, mac.length);
        for (int i = 0; i != mac.length; ++i) {
            sum[i] = (byte)(sum[i] ^ mac[i]);
        }
        return sum;
    }

    public void update(byte in) throws IllegalStateException {
        if (this.bufOff == this.buf.length) {
            byte[] sumbuf = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, sumbuf, 0, this.mac.length);
            if (this.firstStep) {
                this.firstStep = false;
                if (this.macIV != null) {
                    sumbuf = this.cm5Func(this.buf, 0, this.macIV);
                }
            } else {
                sumbuf = this.cm5Func(this.buf, 0, this.mac);
            }
            this.gost28147MacFunc(sumbuf, this.mac);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = in;
    }

    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int gapLen = this.blockSize - this.bufOff;
        if (len > gapLen) {
            System.arraycopy(in, inOff, this.buf, this.bufOff, gapLen);
            byte[] sumbuf = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, sumbuf, 0, this.mac.length);
            if (this.firstStep) {
                this.firstStep = false;
                if (this.macIV != null) {
                    sumbuf = this.cm5Func(this.buf, 0, this.macIV);
                }
            } else {
                sumbuf = this.cm5Func(this.buf, 0, this.mac);
            }
            this.gost28147MacFunc(sumbuf, this.mac);
            this.bufOff = 0;
            len -= gapLen;
            inOff += gapLen;
            while (len > this.blockSize) {
                sumbuf = this.cm5Func(in, inOff, this.mac);
                this.gost28147MacFunc(sumbuf, this.mac);
                len -= this.blockSize;
                inOff += this.blockSize;
            }
        }
        System.arraycopy(in, inOff, this.buf, this.bufOff, len);
        this.bufOff += len;
    }

    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        while (this.bufOff < this.blockSize) {
            this.buf[this.bufOff] = 0;
            ++this.bufOff;
        }
        byte[] sumbuf = new byte[this.buf.length];
        System.arraycopy(this.buf, 0, sumbuf, 0, this.mac.length);
        if (this.firstStep) {
            this.firstStep = false;
        } else {
            sumbuf = this.cm5Func(this.buf, 0, this.mac);
        }
        this.gost28147MacFunc(sumbuf, this.mac);
        System.arraycopy(this.mac, this.mac.length / 2 - this.macSize, out, outOff, this.macSize);
        this.reset();
        return this.macSize;
    }

    public void reset() {
        for (int i = 0; i < this.buf.length; ++i) {
            this.buf[i] = 0;
        }
        this.bufOff = 0;
        this.firstStep = true;
    }

    public void reset(Memoable other) {
        GOST28147Mac t = (GOST28147Mac)other;
        this.bufOff = t.bufOff;
        this.firstStep = t.firstStep;
        this.processedBytes = t.processedBytes;
        System.arraycopy(t.buf, 0, this.buf, 0, t.buf.length);
        System.arraycopy(t.mac, 0, this.mac, 0, t.mac.length);
        System.arraycopy(t.sbox, 0, this.sbox, 0, t.sbox.length);
        if (t.key != null) {
            System.arraycopy(t.key, 0, this.key, 0, t.key.length);
            this.workingKey = this.generateWorkingKey(this.key);
        }
        if (t.macIV != null) {
            System.arraycopy(t.macIV, 0, this.macIV, 0, t.macIV.length);
        }
    }

    public Memoable copy() {
        return new GOST28147Mac(this);
    }
}

