/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.hpke;

import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.tlsattacker.core.constants.hpke.HpkeAeadFunction;
import de.rub.nds.tlsattacker.core.crypto.cipher.CipherWrapper;
import de.rub.nds.tlsattacker.core.crypto.cipher.EncryptionCipher;
import de.rub.nds.tlsattacker.core.crypto.hpke.HpkeContext;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;

public class HpkeSenderContext
extends HpkeContext {
    public HpkeSenderContext(byte[] aeadKey, byte[] baseNonce, int sequenceNumber, byte[] exporterSecret, HpkeAeadFunction hpkeAeadFunction) {
        super(aeadKey, baseNonce, sequenceNumber, exporterSecret, hpkeAeadFunction);
    }

    public byte[] seal(byte[] additionalAuthenticatedData, byte[] plaintext, byte[] nonce) throws CryptoException {
        KeySet keySet = new KeySet();
        keySet.setClientWriteKey(this.aeadKey);
        EncryptionCipher encryptionCipher = CipherWrapper.getEncryptionCipher(this.hpkeAeadFunction.getCipherSuite(), ConnectionEndType.CLIENT, keySet);
        byte[] ciphertext = encryptionCipher.encrypt(nonce, this.hpkeAeadFunction.getTagLength() * 8, additionalAuthenticatedData, plaintext);
        this.incrementSequenceNumber();
        return ciphertext;
    }

    public byte[] seal(byte[] additionalAuthenticatedData, byte[] plaintext) throws CryptoException {
        return this.seal(additionalAuthenticatedData, plaintext, this.computeNonce());
    }
}

