/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.mac;

import de.rub.nds.protocol.constants.MacAlgorithm;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.crypto.gost.GOST28147Mac;
import de.rub.nds.tlsattacker.core.crypto.mac.ContinuousMac;
import de.rub.nds.tlsattacker.core.crypto.mac.JavaMac;
import de.rub.nds.tlsattacker.core.crypto.mac.WrappedMac;
import de.rub.nds.tlsattacker.core.util.GOSTUtils;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.digests.GOST3411Digest;
import org.bouncycastle.crypto.digests.GOST3411_2012_256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithSBox;
import org.bouncycastle.util.Memoable;

public class MacWrapper {
    public static WrappedMac getMac(ProtocolVersion version, CipherSuite cipherSuite, byte[] key) throws NoSuchAlgorithmException {
        MacAlgorithm macAlg = AlgorithmResolver.getMacAlgorithm(version, cipherSuite);
        if (macAlg == MacAlgorithm.HMAC_GOSTR3411) {
            GOST3411Digest digest = new GOST3411Digest();
            return new ContinuousMac((Mac)new HMac((Digest)digest), (Memoable)digest, (CipherParameters)new KeyParameter(key));
        }
        if (macAlg == MacAlgorithm.HMAC_GOSTR3411_2012_256) {
            GOST3411_2012_256Digest digest = new GOST3411_2012_256Digest();
            return new ContinuousMac((Mac)new HMac((Digest)digest), (Memoable)digest, (CipherParameters)new KeyParameter(key));
        }
        if (macAlg == MacAlgorithm.IMIT_GOST28147) {
            ParametersWithSBox parameters = new ParametersWithSBox((CipherParameters)new KeyParameter(key), GOSTUtils.getGostSBox(cipherSuite));
            return new ContinuousMac(new GOST28147Mac(), (CipherParameters)parameters);
        }
        if (macAlg.getJavaName() != null) {
            return new JavaMac(macAlg.getJavaName(), key);
        }
        throw new NoSuchAlgorithmException("Mac: " + String.valueOf(macAlg) + " is not supported!");
    }
}

