/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.dtls;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.dtls.FragmentStream;
import de.rub.nds.tlsattacker.core.dtls.serializer.DtlsHandshakeMessageFragmentSerializer;
import de.rub.nds.tlsattacker.core.exceptions.IllegalDtlsFragmentException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FragmentCollector {
    private static final Logger LOGGER = LogManager.getLogger();
    private Integer messageLength;
    private Integer messageSeq;
    private Byte type;
    private boolean interpreted = false;
    private boolean retransmission = false;
    private final Config config;
    private FragmentStream fragmentStream;

    public FragmentCollector(Config config, Byte type, int messageSeq, int messageLength) {
        this.config = config;
        this.fragmentStream = new FragmentStream(messageLength);
        this.type = type;
        this.messageLength = messageLength;
        this.messageSeq = messageSeq;
    }

    public void addFragment(DtlsHandshakeMessageFragment fragment) {
        if (this.wouldAdd(fragment)) {
            if (this.isFragmentOverwritingContent(fragment)) {
                LOGGER.warn("Found a fragment which tries to rewrite history. Setting interpreted to false and resetting Stream.");
                this.fragmentStream = new FragmentStream((Integer)fragment.getLength().getValue());
                this.messageLength = (Integer)fragment.getLength().getValue();
                this.messageSeq = (Integer)fragment.getMessageSequence().getValue();
                this.type = (Byte)fragment.getType().getValue();
                this.interpreted = false;
                this.retransmission = false;
            }
            if (this.interpreted && this.config.isAddRetransmissionsToWorkflowTraceInDtls().booleanValue()) {
                this.fragmentStream = new FragmentStream((Integer)fragment.getLength().getValue());
                this.messageLength = (Integer)fragment.getLength().getValue();
                this.messageSeq = (Integer)fragment.getMessageSequence().getValue();
                this.type = (Byte)fragment.getType().getValue();
                this.interpreted = false;
                this.retransmission = true;
            }
        } else {
            throw new IllegalDtlsFragmentException("Tried to insert an illegal DTLS fragment.");
        }
        this.fragmentStream.insertByteArray((byte[])fragment.getFragmentContent().getValue(), (Integer)fragment.getFragmentOffset().getValue());
    }

    public boolean wouldAdd(DtlsHandshakeMessageFragment fragment) {
        if (this.config.isAcceptContentRewritingDtlsFragments().booleanValue() || !this.isFragmentOverwritingContent(fragment)) {
            if (!this.config.isAcceptOnlyFittingDtlsFragments().booleanValue() || this.isFitting(fragment)) {
                return true;
            }
            LOGGER.warn("Would not add not fitting fragment");
            return false;
        }
        LOGGER.warn("Received history rewriting fragment");
        return false;
    }

    public boolean isFitting(DtlsHandshakeMessageFragment fragment) {
        if (((Byte)fragment.getType().getValue()).equals(this.type) && ((Integer)fragment.getMessageSequence().getValue()).equals(this.messageSeq) && ((Integer)fragment.getLength().getValue()).equals(this.messageLength)) {
            return this.fragmentStream.canInsertByteArray((byte[])fragment.getFragmentContent().getValue(), (Integer)fragment.getFragmentOffset().getValue());
        }
        return false;
    }

    public boolean isFragmentOverwritingContent(DtlsHandshakeMessageFragment fragment) {
        return !this.fragmentStream.canInsertByteArray((byte[])fragment.getFragmentContent().getValue(), (Integer)fragment.getFragmentOffset().getValue());
    }

    public DtlsHandshakeMessageFragment buildCombinedFragment() {
        if (!this.isMessageComplete()) {
            LOGGER.warn("Returning incompletely received message! Missing pieces are ignored in the content.");
        }
        DtlsHandshakeMessageFragment message = new DtlsHandshakeMessageFragment();
        message.setType(this.type);
        message.setLength(this.messageLength);
        message.setMessageSequence(this.messageSeq);
        message.setFragmentOffset(0);
        message.setFragmentLength(this.messageLength);
        message.setFragmentContent(this.getCombinedContent());
        DtlsHandshakeMessageFragmentSerializer serializer = new DtlsHandshakeMessageFragmentSerializer(message);
        message.setCompleteResultingMessage(serializer.serialize());
        this.interpreted = true;
        return message;
    }

    private byte[] getCombinedContent() {
        return this.fragmentStream.getCompleteTruncatedStream();
    }

    public boolean isMessageComplete() {
        return this.fragmentStream.isComplete(this.messageLength);
    }

    public boolean isInterpreted() {
        return this.interpreted;
    }

    public void setInterpreted(boolean interpreted) {
        this.interpreted = interpreted;
    }

    public boolean isRetransmission() {
        return this.retransmission;
    }

    public void setRetransmission(boolean retransmission) {
        this.retransmission = retransmission;
    }
}

