/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.dtls.preparator;

import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.layer.data.Preparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DtlsHandshakeMessageFragmentPreparator
extends Preparator<DtlsHandshakeMessageFragment> {
    private static final Logger LOGGER = LogManager.getLogger();
    private DtlsHandshakeMessageFragment msg;

    public DtlsHandshakeMessageFragmentPreparator(Chooser chooser, DtlsHandshakeMessageFragment message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepare() {
        this.prepareHandshakeType(this.msg);
        this.msg.setFragmentContent(this.msg.getFragmentContentConfig());
        this.msg.setLength(this.msg.getHandshakeMessageLengthConfig());
        this.msg.setMessageSequence(this.msg.getMessageSequenceConfig());
        this.msg.setFragmentOffset(this.msg.getOffsetConfig());
        this.msg.setFragmentLength(((byte[])this.msg.getFragmentContent().getValue()).length);
    }

    private void prepareHandshakeType(DtlsHandshakeMessageFragment message) {
        HandshakeMessageType handshakeType = message.getHandshakeMessageTypeConfig();
        if (handshakeType == null && (handshakeType = this.msg.getHandshakeMessageType()) == null) {
            handshakeType = HandshakeMessageType.UNKNOWN;
        }
        message.setType(handshakeType.getValue());
    }
}

