/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.dtls.serializer;

import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DtlsHandshakeMessageFragmentSerializer
extends Serializer<DtlsHandshakeMessageFragment> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DtlsHandshakeMessageFragment fragment;

    public DtlsHandshakeMessageFragmentSerializer(DtlsHandshakeMessageFragment fragment) {
        this.fragment = fragment;
    }

    @Override
    protected byte[] serializeBytes() {
        this.writeType();
        this.writeLength();
        this.writeMessageSequence();
        this.writeFragmentOffset();
        this.writeFragmentLength();
        this.writeContent();
        return this.getAlreadySerialized();
    }

    protected void writeType() {
        this.appendByte((Byte)this.fragment.getType().getValue());
        LOGGER.debug("Type: {}", this.fragment.getType().getValue());
    }

    protected void writeLength() {
        this.appendInt((Integer)this.fragment.getLength().getValue(), 3);
        LOGGER.debug("Length: {}", this.fragment.getLength().getValue());
    }

    private void writeContent() {
        this.appendBytes((byte[])this.fragment.getFragmentContent().getValue());
        LOGGER.debug("DTLS fragment content: {}", this.fragment.getFragmentContent().getValue());
    }

    private void writeMessageSequence() {
        this.appendInt((Integer)this.fragment.getMessageSequence().getValue(), 2);
        LOGGER.debug("SequenceNumber: {}", this.fragment.getMessageSequence().getValue());
    }

    private void writeFragmentOffset() {
        this.appendInt((Integer)this.fragment.getFragmentOffset().getValue(), 3);
        LOGGER.debug("FragmentOffset: {}", this.fragment.getFragmentOffset().getValue());
    }

    private void writeFragmentLength() {
        this.appendInt((Integer)this.fragment.getFragmentLength().getValue(), 3);
        LOGGER.debug("FragmentLength: {}", this.fragment.getFragmentLength().getValue());
    }
}

