/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.http;

import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.tlsattacker.core.http.HttpMessageParser;
import de.rub.nds.tlsattacker.core.http.HttpRequestMessage;
import de.rub.nds.tlsattacker.core.http.header.ContentLengthHeader;
import de.rub.nds.tlsattacker.core.http.header.DateHeader;
import de.rub.nds.tlsattacker.core.http.header.ExpiresHeader;
import de.rub.nds.tlsattacker.core.http.header.GenericHttpHeader;
import de.rub.nds.tlsattacker.core.http.header.HostHeader;
import de.rub.nds.tlsattacker.core.http.header.HttpHeader;
import de.rub.nds.tlsattacker.core.http.header.LocationHeader;
import de.rub.nds.tlsattacker.core.http.header.TokenBindingHeader;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpRequestParser
extends HttpMessageParser<HttpRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HttpRequestParser(InputStream stream) {
        super(stream);
    }

    @Override
    public void parse(HttpRequestMessage message) {
        String request = this.parseStringTill((byte)10).trim();
        String[] split = request.replaceAll("\r", " ").split(" ");
        if (split.length != 3) {
            throw new ParserException("Could not parse as HttpRequestMessage");
        }
        message.setRequestType(split[0]);
        message.setRequestPath(split[1]);
        message.setRequestProtocol(split[2]);
        String line = this.parseStringTill((byte)10);
        while (!line.trim().isEmpty()) {
            split = line.split(": ");
            if (split.length < 2) {
                throw new ParserException("Could not parse " + String.valueOf(split) + " as HttpHeader");
            }
            String headerName = split[0];
            String headerValue = line.replaceFirst(Pattern.quote(split[0] + ":"), "").replaceAll("\n", "").replaceAll("\r", "").trim();
            HttpHeader header = switch (headerName.toLowerCase()) {
                case "host" -> new HostHeader();
                case "sec-token-binding" -> new TokenBindingHeader();
                case "location" -> new LocationHeader();
                case "content-length" -> new ContentLengthHeader();
                case "expires" -> new ExpiresHeader();
                case "date" -> new DateHeader();
                default -> new GenericHttpHeader();
            };
            header.setHeaderName(headerName);
            header.setHeaderValue(headerValue);
            message.getHeader().add(header);
            line = this.parseStringTill((byte)10);
        }
        LOGGER.info(new String(this.getAlreadyParsed(), StandardCharsets.US_ASCII));
    }
}

