/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.http;

import de.rub.nds.tlsattacker.core.http.HttpMessageSerializer;
import de.rub.nds.tlsattacker.core.http.HttpRequestMessage;
import de.rub.nds.tlsattacker.core.http.header.HttpHeader;
import de.rub.nds.tlsattacker.core.http.header.serializer.HttpHeaderSerializer;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpRequestSerializer
extends HttpMessageSerializer<HttpRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HttpRequestMessage message;

    public HttpRequestSerializer(HttpRequestMessage message) {
        super(message);
        this.message = message;
    }

    @Override
    protected byte[] serializeBytes() {
        StringBuilder builder = new StringBuilder();
        builder.append((String)this.message.getRequestType().getValue()).append(" ").append((String)this.message.getRequestPath().getValue()).append(" ").append((String)this.message.getRequestProtocol().getValue()).append("\r\n");
        for (HttpHeader header : this.message.getHeader()) {
            HttpHeaderSerializer serializer = new HttpHeaderSerializer(header);
            builder.append(new String(serializer.serialize(), StandardCharsets.ISO_8859_1));
        }
        builder.append("\r\n");
        LOGGER.debug(builder.toString());
        this.appendBytes(builder.toString().getBytes(StandardCharsets.ISO_8859_1));
        return this.getAlreadySerialized();
    }
}

