/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.http;

import de.rub.nds.protocol.exception.ParserException;
import de.rub.nds.tlsattacker.core.http.HttpMessageParser;
import de.rub.nds.tlsattacker.core.http.HttpResponseMessage;
import de.rub.nds.tlsattacker.core.http.header.ContentLengthHeader;
import de.rub.nds.tlsattacker.core.http.header.DateHeader;
import de.rub.nds.tlsattacker.core.http.header.ExpiresHeader;
import de.rub.nds.tlsattacker.core.http.header.GenericHttpHeader;
import de.rub.nds.tlsattacker.core.http.header.HostHeader;
import de.rub.nds.tlsattacker.core.http.header.HttpHeader;
import de.rub.nds.tlsattacker.core.http.header.LocationHeader;
import de.rub.nds.tlsattacker.core.http.header.TokenBindingHeader;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpResponseParser
extends HttpMessageParser<HttpResponseMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final byte LINEBREAK_BYTE = 10;
    private final int maxHttpLength;
    private ContentLengthHeader contentLengthHeader;
    private GenericHttpHeader transferEncodingHeader;

    public HttpResponseParser(InputStream stream, int maxHttpLength) {
        super(stream);
        this.maxHttpLength = maxHttpLength;
    }

    @Override
    public void parse(HttpResponseMessage message) {
        String request = this.parseStringTill((byte)10);
        String[] split = request.replace("\r", " ").split(" ");
        if (split.length < 2) {
            throw new ParserException("Could not parse as HttpsResponseMessage");
        }
        message.setResponseProtocol(split[0]);
        message.setResponseStatusCode(request.replaceFirst(Pattern.quote(split[0] + " "), "").trim());
        message.setHeader(this.parseHeaders());
        if (this.contentLengthHeader != null && this.transferEncodingHeader != null) {
            LOGGER.warn("HTTP message contains both Content-Length and Transfer-Encoding headers, assuming Content-Length");
        }
        StringBuilder httpMessageBuilder = new StringBuilder();
        if (this.contentLengthHeader != null) {
            this.parseContentLength(this.contentLengthHeader, httpMessageBuilder);
        } else if (this.transferEncodingHeader != null) {
            this.parseChunked(httpMessageBuilder, message);
        } else {
            httpMessageBuilder.append(new String(this.parseTillEnd(), StandardCharsets.UTF_8));
        }
        message.setResponseContent(httpMessageBuilder.toString());
        LOGGER.debug(() -> new String(this.getAlreadyParsed(), StandardCharsets.UTF_8));
    }

    private List<HttpHeader> parseHeaders() {
        String line = this.parseStringTill((byte)10);
        LinkedList<HttpHeader> headers = new LinkedList<HttpHeader>();
        while (!line.trim().isEmpty()) {
            HttpHeader header;
            Object[] split = line.split(": ");
            if (split.length < 2) {
                throw new ParserException("Could not parse " + Arrays.toString(split) + " as HttpHeader");
            }
            String headerName = split[0];
            String headerValue = line.replaceFirst(Pattern.quote((String)split[0] + ":"), "").replace("\n", "").replace("\r", "").trim();
            switch (headerName.toLowerCase()) {
                case "host": {
                    header = new HostHeader();
                    break;
                }
                case "sec-token-binding": {
                    header = new TokenBindingHeader();
                    break;
                }
                case "location": {
                    header = new LocationHeader();
                    break;
                }
                case "content-length": {
                    header = new ContentLengthHeader();
                    this.contentLengthHeader = (ContentLengthHeader)header;
                    break;
                }
                case "expires": {
                    header = new ExpiresHeader();
                    break;
                }
                case "date": {
                    header = new DateHeader();
                    break;
                }
                case "transfer-encoding": {
                    header = new GenericHttpHeader();
                    this.transferEncodingHeader = (GenericHttpHeader)header;
                    break;
                }
                default: {
                    header = new GenericHttpHeader();
                }
            }
            header.setHeaderName(headerName);
            header.setHeaderValue(headerValue);
            headers.add(header);
            line = this.parseStringTill((byte)10);
        }
        return headers;
    }

    private void parseContentLength(ContentLengthHeader contentLengthHeader, StringBuilder httpMessageBuilder) {
        int bytesToRead;
        LOGGER.debug("Parsing HTTP message with Content Length Header");
        try {
            bytesToRead = Integer.parseInt((String)contentLengthHeader.getHeaderValue().getValue());
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Server send invalid content length header, header value {} cannot be parsed to int", contentLengthHeader.getHeaderValue().getValue());
            bytesToRead = this.getBytesLeft();
        }
        if (bytesToRead > this.maxHttpLength) {
            LOGGER.warn("Received a HTTP message with size {}, truncating to maximum specified size {}", (Object)bytesToRead, (Object)this.maxHttpLength);
            bytesToRead = this.maxHttpLength;
        }
        byte[] content = this.parseByteArrayField(bytesToRead);
        httpMessageBuilder.append(new String(content, StandardCharsets.UTF_8));
        if (content.length < bytesToRead) {
            LOGGER.warn("Content-Length header value was larger ({}B) than actual content ({}B)", (Object)bytesToRead, (Object)content.length);
        }
    }

    private void parseChunked(StringBuilder httpMessageBuilder, HttpResponseMessage message) {
        LOGGER.debug("Parsing HTTP message with chunked encoding.");
        boolean reachedEnd = false;
        int parsedLen = 0;
        while (!reachedEnd && parsedLen < this.maxHttpLength) {
            int length;
            try {
                length = Integer.parseInt(this.parseStringTill((byte)10).trim(), 16);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Invalid Chunked Encoding in HTTP message: ", (Throwable)e);
                return;
            }
            if (length == 0) {
                reachedEnd = true;
                message.setTrailer(this.parseHeaders());
                continue;
            }
            if (length >= this.maxHttpLength - parsedLen) {
                length = this.maxHttpLength - parsedLen;
                LOGGER.warn("Received a chunked HTTP message that is larger than the maximum specified size {}, truncating.", (Object)this.maxHttpLength);
            }
            parsedLen += length;
            byte[] content = this.parseByteArrayField(length);
            httpMessageBuilder.append(new String(content, StandardCharsets.UTF_8));
            this.parseByteArrayField(2);
        }
    }
}

