/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.http;

import de.rub.nds.tlsattacker.core.http.HttpMessagePreparator;
import de.rub.nds.tlsattacker.core.http.HttpResponseMessage;
import de.rub.nds.tlsattacker.core.http.header.ContentLengthHeader;
import de.rub.nds.tlsattacker.core.http.header.HttpHeader;
import de.rub.nds.tlsattacker.core.layer.context.HttpContext;
import java.nio.charset.StandardCharsets;

public class HttpResponsePreparator
extends HttpMessagePreparator<HttpResponseMessage> {
    private final HttpResponseMessage message;
    private final HttpContext httpContext;

    public HttpResponsePreparator(HttpContext httpContext, HttpResponseMessage message) {
        super(httpContext.getChooser(), message);
        this.httpContext = httpContext;
        this.message = message;
    }

    @Override
    protected void prepareHttpMessageContents() {
        this.message.setResponseProtocol("HTTP/1.1");
        this.message.setResponseStatusCode("200 OK");
        this.message.setResponseContent(this.chooser.getConfig().getDefaultApplicationMessageData());
        for (HttpHeader header : this.message.getHeader()) {
            this.prepareSingleHeader(header);
        }
        for (HttpHeader header : this.message.getTrailer()) {
            this.prepareSingleHeader(header);
        }
    }

    private void prepareSingleHeader(HttpHeader header) {
        if (header instanceof ContentLengthHeader) {
            ((ContentLengthHeader)header).setConfigLength(((String)this.message.getResponseContent().getValue()).getBytes(StandardCharsets.ISO_8859_1).length);
        }
        header.getPreparator(this.httpContext.getContext()).prepare();
    }
}

