/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.http;

import de.rub.nds.tlsattacker.core.http.HttpMessageSerializer;
import de.rub.nds.tlsattacker.core.http.HttpResponseMessage;
import de.rub.nds.tlsattacker.core.http.header.HttpHeader;
import de.rub.nds.tlsattacker.core.http.header.serializer.HttpHeaderSerializer;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpResponseSerializer
extends HttpMessageSerializer<HttpResponseMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HttpResponseMessage message;

    public HttpResponseSerializer(HttpResponseMessage message) {
        super(message);
        this.message = message;
    }

    @Override
    protected byte[] serializeBytes() {
        StringBuilder builder = new StringBuilder();
        builder.append((String)this.message.getResponseProtocol().getValue()).append(" ").append((String)this.message.getResponseStatusCode().getValue()).append("\r\n");
        for (HttpHeader header : this.message.getHeader()) {
            HttpHeaderSerializer serializer = new HttpHeaderSerializer(header);
            builder.append(new String(serializer.serialize(), StandardCharsets.ISO_8859_1));
        }
        builder.append("\r\n");
        builder.append((String)this.message.getResponseContent().getValue());
        LOGGER.info(builder.toString());
        this.appendBytes(builder.toString().getBytes(StandardCharsets.ISO_8859_1));
        return this.getAlreadySerialized();
    }
}

