/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.http.header.preparator;

import de.rub.nds.tlsattacker.core.http.header.LocationHeader;
import de.rub.nds.tlsattacker.core.layer.context.HttpContext;
import de.rub.nds.tlsattacker.core.layer.data.Preparator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocationHeaderPreparator
extends Preparator<LocationHeader> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final LocationHeader header;
    private final HttpContext httpContext;

    public LocationHeaderPreparator(HttpContext httpContext, LocationHeader header) {
        super(httpContext.getChooser(), header);
        this.httpContext = httpContext;
        this.header = header;
    }

    @Override
    public void prepare() {
        this.header.setHeaderName("Location");
        String lastRequestPath = this.httpContext.getLastRequestPath();
        if (lastRequestPath != null) {
            this.header.setHeaderValue(lastRequestPath);
        } else {
            LOGGER.debug("Request path was not set or interpreted during the connection, we use default value from the config instead");
            this.header.setHeaderValue(this.chooser.getConfig().getDefaultHttpsLocationPath());
        }
    }
}

