/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer;

import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.List;
import java.util.StringJoiner;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LayerProcessingResult<Container extends DataContainer> {
    @XmlAnyElement(lax=true)
    private List<Container> usedContainers;
    @XmlAnyElement(lax=true)
    private LayerType layerType;
    private boolean executedAsPlanned;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] unreadBytes;

    private LayerProcessingResult() {
    }

    public LayerProcessingResult(List<Container> usedContainers, LayerType layerType, boolean executedAsPlanned, byte[] unreadBytes) {
        this.usedContainers = usedContainers;
        this.layerType = layerType;
        this.executedAsPlanned = executedAsPlanned;
        this.unreadBytes = unreadBytes;
    }

    public LayerProcessingResult(List<Container> usedContainers, LayerType layerType, boolean executedAsPlanned) {
        this.usedContainers = usedContainers;
        this.layerType = layerType;
        this.executedAsPlanned = executedAsPlanned;
        this.unreadBytes = new byte[0];
    }

    public List<Container> getUsedContainers() {
        return this.usedContainers;
    }

    public void setUsedContainers(List<Container> usedContainers) {
        this.usedContainers = usedContainers;
    }

    public LayerType getLayerType() {
        return this.layerType;
    }

    public boolean isExecutedAsPlanned() {
        return this.executedAsPlanned;
    }

    public void setExecutedAsPlanned(boolean executedAsPlanned) {
        this.executedAsPlanned = executedAsPlanned;
    }

    public void setLayerType(LayerType layerType) {
        this.layerType = layerType;
    }

    public byte[] getUnreadBytes() {
        return this.unreadBytes;
    }

    public void setUnreadBytes(byte[] unreadBytes) {
        this.unreadBytes = unreadBytes;
    }

    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LayerType: ");
        sb.append(this.layerType);
        sb.append(" As Planned: ");
        sb.append(this.executedAsPlanned);
        sb.append(" Containers: ");
        StringJoiner joiner = new StringJoiner(", ");
        for (DataContainer container : this.usedContainers) {
            joiner.add(container.toCompactString());
        }
        sb.append(joiner.toString());
        sb.append(" UnreadBytes: ");
        sb.append(this.unreadBytes.length);
        return sb.toString();
    }
}

