/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer;

import de.rub.nds.tlsattacker.core.layer.IgnoreLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerStackProcessingResult;
import de.rub.nds.tlsattacker.core.layer.ProtocolLayer;
import de.rub.nds.tlsattacker.core.layer.ReceiveTillLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import de.rub.nds.tlsattacker.core.layer.impl.QuicFrameLayer;
import de.rub.nds.tlsattacker.core.state.Context;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LayerStack {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<ProtocolLayer<?, ?, ?>> layerList;
    private final Context context;

    public LayerStack(Context context, ProtocolLayer ... layers) {
        this.context = context;
        this.layerList = Arrays.asList(layers);
        for (int i = 0; i < layers.length; ++i) {
            ProtocolLayer<?, ?, ?> layer = this.layerList.get(i);
            if (i != 0) {
                layer.setHigherLayer(this.layerList.get(i - 1));
            }
            if (i == layers.length - 1) continue;
            layer.setLowerLayer(this.layerList.get(i + 1));
        }
    }

    public final ProtocolLayer getLayer(Class<? extends ProtocolLayer> layerClass) {
        for (ProtocolLayer<?, ?, ?> layer : this.getLayerList()) {
            if (!layer.getClass().equals(layerClass)) continue;
            return layer;
        }
        return null;
    }

    public ProtocolLayer getHighestLayer() {
        return this.getTopConfiguredLayer();
    }

    public ProtocolLayer getLowestLayer() {
        return this.getLayerList().get(this.getLayerList().size() - 1);
    }

    public LayerStackProcessingResult sendData(List<LayerConfiguration<? extends DataContainer>> layerConfigurationList) throws IOException {
        LOGGER.debug("Sending Data");
        if (this.getLayerList().size() != layerConfigurationList.size()) {
            throw new RuntimeException("Illegal LayerConfiguration list provided. Each layer needs a configuration entry (null is fine too if no explicit configuration is desired). Expected " + this.getLayerList().size() + " but found " + layerConfigurationList.size());
        }
        for (int i = 0; i < this.getLayerList().size(); ++i) {
            ProtocolLayer<? extends DataContainer, ? extends DataContainer, ? extends DataContainer> protocolLayer = this.getLayerList().get(i);
            protocolLayer.clear();
            protocolLayer.setLayerConfiguration(layerConfigurationList.get(i));
        }
        this.context.setTalkingConnectionEndType(this.context.getConnection().getLocalConnectionEndType());
        for (ProtocolLayer<?, ?, ?> protocolLayer : this.getLayerList()) {
            protocolLayer.sendConfiguration();
        }
        LinkedList resultList = new LinkedList();
        this.getLayerList().forEach(layer -> resultList.add(layer.getLayerResult()));
        return new LayerStackProcessingResult(resultList);
    }

    public LayerStackProcessingResult receiveData(List<LayerConfiguration<? extends DataContainer>> layerConfigurationList) {
        if (this.getLayerList().size() != layerConfigurationList.size()) {
            throw new RuntimeException("Illegal LayerConfiguration list provided. Each layer needs a configuration entry. Expected " + this.getLayerList().size() + " but found " + layerConfigurationList.size());
        }
        for (int i = 0; i < this.getLayerList().size(); ++i) {
            ProtocolLayer<? extends DataContainer, ? extends DataContainer, ? extends DataContainer> layer = this.getLayerList().get(i);
            layer.clear();
            layer.setLayerConfiguration(layerConfigurationList.get(i));
        }
        this.context.setTalkingConnectionEndType(this.context.getConnection().getLocalConnectionEndType().getPeer());
        ProtocolLayer topLayer = this.getTopConfiguredLayer();
        topLayer.receiveData();
        Optional<ProtocolLayer> quicFrameLayer = this.getLayerList().stream().filter(x -> x instanceof QuicFrameLayer).findFirst();
        if (quicFrameLayer.isPresent() && quicFrameLayer.get().getLayerConfiguration() instanceof ReceiveTillLayerConfiguration) {
            int remainingTries = ((ReceiveTillLayerConfiguration)quicFrameLayer.get().getLayerConfiguration()).getMaxNumberOfQuicPacketsToReceive();
            if (remainingTries > 0) {
                while (remainingTries > 0 && quicFrameLayer.get().shouldContinueProcessing()) {
                    quicFrameLayer.get().receiveData();
                    --remainingTries;
                }
            } else {
                while (quicFrameLayer.get().shouldContinueProcessing() && !((QuicFrameLayer)quicFrameLayer.get()).hasExperiencedTimeout()) {
                    quicFrameLayer.get().receiveData();
                }
            }
        }
        for (int i = this.getLayerList().size() - 1; i >= 0; --i) {
            ProtocolLayer<?, ?, ?> layer = this.getLayerList().get(i);
            if (layer.getLayerConfiguration() == null || layer.getLayerConfiguration() instanceof IgnoreLayerConfiguration || layer.executedAsPlanned()) continue;
            try {
                layer.receiveData();
                continue;
            }
            catch (UnsupportedOperationException e) {
                LOGGER.debug("Skipping layer {}. Does not support direct data read.", (Object)layer.getLayerType());
            }
        }
        return this.gatherResults();
    }

    private ProtocolLayer getTopConfiguredLayer() {
        for (int i = 0; i < this.getLayerList().size(); ++i) {
            ProtocolLayer<?, ?, ?> layer = this.getLayerList().get(i);
            if (layer.getLayerConfiguration() == null || layer.getLayerConfiguration() instanceof IgnoreLayerConfiguration) continue;
            return layer;
        }
        StringBuilder debugInformation = new StringBuilder();
        for (ProtocolLayer<?, ?, ?> layer : this.getLayerList()) {
            debugInformation.append(layer.getLayerType());
            debugInformation.append(" ");
            debugInformation.append(layer.getLayerConfiguration());
            debugInformation.append("\n");
        }
        throw new RuntimeException("No configured layer found. All layers are ignored. " + debugInformation.toString());
    }

    public LayerStackProcessingResult gatherResults() {
        LinkedList resultList = new LinkedList();
        this.getLayerList().forEach(tempLayer -> resultList.add(tempLayer.getLayerResult()));
        return new LayerStackProcessingResult(resultList);
    }

    public List<LayerType> getLayersInStack() {
        return this.layerList.stream().map(ProtocolLayer::getLayerType).collect(Collectors.toList());
    }

    public List<ProtocolLayer<?, ?, ?>> getLayerList() {
        return Collections.unmodifiableList(this.layerList);
    }
}

