/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer;

import de.rub.nds.tlsattacker.core.http.HttpResponseMessage;
import de.rub.nds.tlsattacker.core.layer.ReceiveLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import java.util.List;
import org.apache.logging.log4j.Level;

public class ReceiveTillHttpContentConfiguration
extends ReceiveLayerConfiguration<HttpResponseMessage> {
    private final String desiredContent;

    public ReceiveTillHttpContentConfiguration(List<HttpResponseMessage> httpMessages, String desiredContent) {
        super((LayerType)ImplementedLayers.HTTP, httpMessages);
        this.desiredContent = desiredContent;
    }

    @Override
    public boolean executedAsPlanned(List<HttpResponseMessage> list) {
        StringBuilder stringBuilder = new StringBuilder();
        list.stream().map(e -> (String)e.getResponseContent().getValue()).forEach(stringBuilder::append);
        String content = stringBuilder.toString();
        return content.contains(this.desiredContent);
    }

    @Override
    public String toCompactString() {
        return "(" + this.getLayerType().getName() + ") ReceiveTillHttpContent: " + this.desiredContent;
    }

    @Override
    public boolean shouldContinueProcessing(List<HttpResponseMessage> list, boolean receivedTimeout, boolean dataLeftToProcess) {
        if (!this.executedAsPlanned(list)) {
            return !receivedTimeout || dataLeftToProcess;
        }
        return false;
    }

    @Override
    public boolean shouldBeLogged(Level level) {
        return true;
    }
}

