/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer;

import de.rub.nds.tlsattacker.core.layer.ReceiveLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;

public class ReceiveTillLayerConfiguration<Container extends DataContainer>
extends ReceiveLayerConfiguration<Container> {
    private boolean processTrailingContainers = true;
    private int maxNumberOfQuicPacketsToReceive;

    @SafeVarargs
    public ReceiveTillLayerConfiguration(LayerType layerType, Container ... expectedContainers) {
        super(layerType, Arrays.asList(expectedContainers));
    }

    public ReceiveTillLayerConfiguration(LayerType layerType, List<Container> expectedContainers) {
        super(layerType, expectedContainers);
    }

    @SafeVarargs
    public ReceiveTillLayerConfiguration(LayerType layerType, boolean processTrailingContainers, Container ... expectedContainers) {
        this(layerType, processTrailingContainers, Arrays.asList(expectedContainers));
    }

    public ReceiveTillLayerConfiguration(LayerType layerType, boolean processTrailingContainers, List<Container> expectedContainers) {
        super(layerType, expectedContainers);
        this.processTrailingContainers = processTrailingContainers;
    }

    @SafeVarargs
    public ReceiveTillLayerConfiguration(LayerType layerType, boolean processTrailingContainers, int maxNumberOfQuicPacketsToReceive, Container ... expectedContainers) {
        this(layerType, processTrailingContainers, maxNumberOfQuicPacketsToReceive, Arrays.asList(expectedContainers));
    }

    public ReceiveTillLayerConfiguration(LayerType layerType, boolean processTrailingContainers, int maxNumberOfQuicPacketsToReceive, List<Container> expectedContainers) {
        this(layerType, processTrailingContainers, expectedContainers);
        this.maxNumberOfQuicPacketsToReceive = maxNumberOfQuicPacketsToReceive;
    }

    @Override
    public boolean executedAsPlanned(List<Container> list) {
        List missingExpectedContainers = this.getContainerList().stream().map(container -> container.getClass()).collect(Collectors.toList());
        if (list != null) {
            list.forEach(receivedContainer -> missingExpectedContainers.remove(receivedContainer.getClass()));
        }
        return missingExpectedContainers.isEmpty();
    }

    @Override
    public boolean shouldContinueProcessing(List<Container> list, boolean receivedTimeout, boolean dataLeftToProcess) {
        if (receivedTimeout) {
            return false;
        }
        return !this.executedAsPlanned(list) || dataLeftToProcess && this.processTrailingContainers;
    }

    public int getMaxNumberOfQuicPacketsToReceive() {
        return this.maxNumberOfQuicPacketsToReceive;
    }

    @Override
    public String toCompactString() {
        return "(" + this.getLayerType().getName() + ") ReceiveTill:" + this.getContainerList().stream().map(DataContainer::toCompactString).collect(Collectors.joining(","));
    }

    @Override
    public boolean shouldBeLogged(Level level) {
        return true;
    }
}

