/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer;

import de.rub.nds.tlsattacker.core.layer.DataContainerFilter;
import de.rub.nds.tlsattacker.core.layer.ReceiveLayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;

public class SpecificReceiveLayerConfiguration<Container extends DataContainer>
extends ReceiveLayerConfiguration<Container> {
    public SpecificReceiveLayerConfiguration(LayerType layerType, List<Container> containerList) {
        super(layerType, containerList);
    }

    @SafeVarargs
    public SpecificReceiveLayerConfiguration(LayerType layerType, Container ... containers) {
        super(layerType, containers);
    }

    @Override
    public boolean executedAsPlanned(List<Container> list) {
        return this.evaluateReceivedContainers(list, false);
    }

    protected boolean evaluateReceivedContainers(List<Container> list, boolean mayReceiveMoreContainers) {
        if (list == null) {
            return false;
        }
        int j = 0;
        List expectedContainers = this.getContainerList();
        if (expectedContainers != null) {
            for (int i = 0; i < expectedContainers.size(); ++i) {
                if (j >= list.size() && ((DataContainer)expectedContainers.get(i)).isRequired()) {
                    return mayReceiveMoreContainers;
                }
                if (j >= list.size()) continue;
                if (!((DataContainer)expectedContainers.get(i)).getClass().equals(((DataContainer)list.get(j)).getClass()) && ((DataContainer)expectedContainers.get(i)).isRequired()) {
                    if (this.containerCanBeFiltered((DataContainer)list.get(j))) {
                        ++j;
                        --i;
                        continue;
                    }
                    return false;
                }
                if (!((DataContainer)expectedContainers.get(i)).getClass().equals(((DataContainer)list.get(j)).getClass())) continue;
                ++j;
            }
            while (j < list.size()) {
                if (!this.containerCanBeFiltered((DataContainer)list.get(j)) && !mayReceiveMoreContainers) {
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    public void setContainerFilterList(DataContainerFilter ... containerFilters) {
        this.setContainerFilterList(Arrays.asList(containerFilters));
    }

    public boolean containerCanBeFiltered(Container container) {
        if (this.getContainerFilterList() != null) {
            for (DataContainerFilter containerFilter : this.getContainerFilterList()) {
                if (!containerFilter.filterApplies((DataContainer)container)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldContinueProcessing(List<Container> list, boolean receivedTimeout, boolean dataLeftToProcess) {
        if (receivedTimeout && !dataLeftToProcess) {
            return false;
        }
        if (dataLeftToProcess) {
            return true;
        }
        return !this.executedAsPlanned(list);
    }

    @Override
    public String toCompactString() {
        return "(" + this.getLayerType().getName() + ") Receive:" + this.getContainerList().stream().map(DataContainer::toCompactString).collect(Collectors.joining(","));
    }

    @Override
    public boolean shouldBeLogged(Level level) {
        return true;
    }
}

