/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer;

import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.constant.LayerType;
import de.rub.nds.tlsattacker.core.layer.data.DataContainer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;

public class SpecificSendLayerConfiguration<Container extends DataContainer>
extends LayerConfiguration<Container> {
    public SpecificSendLayerConfiguration(LayerType layerType, List<Container> containerList) {
        super(layerType, containerList);
    }

    @SafeVarargs
    public SpecificSendLayerConfiguration(LayerType layerType, Container ... containers) {
        super(layerType, containers);
    }

    @Override
    public boolean executedAsPlanned(List<Container> list) {
        if (list == null) {
            return false;
        }
        if (this.getContainerList() == null) {
            return true;
        }
        return list.size() >= this.getContainerList().size();
    }

    @Override
    public boolean shouldContinueProcessing(List<Container> list, boolean receivedTimeout, boolean dataLeftToProcess) {
        throw new UnsupportedOperationException("This api does not make sense for send layers");
    }

    @Override
    public String toCompactString() {
        return "(" + this.getLayerType().getName() + ") Send:" + this.getContainerList().stream().map(DataContainer::toCompactString).collect(Collectors.joining(","));
    }

    @Override
    public boolean shouldBeLogged(Level level) {
        return true;
    }
}

