/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer.context;

import de.rub.nds.modifiablevariable.util.BadRandom;
import de.rub.nds.modifiablevariable.util.DataConverter;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.AuthzDataFormat;
import de.rub.nds.tlsattacker.core.constants.CertificateStatusRequestType;
import de.rub.nds.tlsattacker.core.constants.CertificateType;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ClientCertificateType;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.EsniDnsKeyRecordVersion;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.GOSTCurve;
import de.rub.nds.tlsattacker.core.constants.HeartbeatMode;
import de.rub.nds.tlsattacker.core.constants.MaxFragmentLength;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.PskKeyExchangeMode;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.constants.SrtpProtectionProfile;
import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.constants.TokenBindingVersion;
import de.rub.nds.tlsattacker.core.constants.UserMappingExtensionHintType;
import de.rub.nds.tlsattacker.core.crypto.MessageDigestCollector;
import de.rub.nds.tlsattacker.core.dtls.DtlsHandshakeMessageFragment;
import de.rub.nds.tlsattacker.core.layer.context.LayerContext;
import de.rub.nds.tlsattacker.core.layer.impl.DtlsFragmentLayer;
import de.rub.nds.tlsattacker.core.layer.impl.RecordLayer;
import de.rub.nds.tlsattacker.core.protocol.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EncryptedClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ack.RecordNumber;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EchConfig;
import de.rub.nds.tlsattacker.core.protocol.message.extension.cachedinfo.CachedObject;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PskSet;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.SNIEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.statusrequestv2.RequestItemV2;
import de.rub.nds.tlsattacker.core.protocol.message.extension.trustedauthority.TrustedAuthority;
import de.rub.nds.tlsattacker.core.record.Record;
import de.rub.nds.tlsattacker.core.record.cipher.RecordNullCipher;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.state.Keylogfile;
import de.rub.nds.tlsattacker.core.state.session.IdSession;
import de.rub.nds.tlsattacker.core.state.session.Session;
import de.rub.nds.tlsattacker.core.state.session.TicketSession;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import de.rub.nds.x509attacker.config.X509CertificateConfig;
import de.rub.nds.x509attacker.context.X509Context;
import de.rub.nds.x509attacker.x509.X509CertificateChain;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class TlsContext
extends LayerContext {
    private List<Session> sessionList;
    private Keylogfile keylogfile;
    private byte[] handshakeSecret;
    private byte[] clientHandshakeTrafficSecret;
    private byte[] serverHandshakeTrafficSecret;
    private byte[] clientApplicationTrafficSecret;
    private byte[] serverApplicationTrafficSecret;
    private byte[] clientEarlyTrafficSecret;
    private KeySet keySetHandshake;
    private CipherSuite earlyDataCipherSuite;
    private byte[] earlySecret;
    private List<PskSet> pskSets;
    private byte[] psk;
    private byte[] earlyDataPsk;
    private byte[] earlyDataPSKIdentity;
    private int selectedIdentityIndex;
    private List<PskKeyExchangeMode> clientPskKeyExchangeModes;
    private Integer maxEarlyDataSize;
    private byte[] masterSecret;
    private byte[] clearKey;
    private byte[] preMasterSecret;
    private byte[] resumptionMasterSecret;
    private byte[] clientExtendedRandom;
    private byte[] serverExtendedRandom;
    private byte[] clientRandom;
    private byte[] serverRandom;
    private CipherSuite selectedCipherSuite;
    private SSL2CipherSuite ssl2CipherSuite;
    private CompressionMethod selectedCompressionMethod;
    private byte[] serverSessionId;
    private byte[] clientSessionId;
    private byte[] ssl2Iv;
    private X509CertificateChain serverCertificateChain;
    private X509CertificateChain clientCertificateChain;
    private MessageDigestCollector digest;
    private byte[] dtlsCookie;
    private byte[] extensionCookie;
    private ProtocolVersion selectedProtocolVersion;
    private ProtocolVersion highestClientProtocolVersion;
    private List<CipherSuite> clientSupportedCipherSuites;
    private List<CompressionMethod> clientSupportedCompressions;
    private List<SignatureAndHashAlgorithm> serverSupportedSignatureAndHashAlgorithms;
    private List<SignatureAndHashAlgorithm> clientSupportedSignatureAndHashAlgorithms;
    private List<SignatureAndHashAlgorithm> clientSupportedCertificateSignAlgorithms;
    private List<SignatureAndHashAlgorithm> serverSupportedCertificateSignAlgorithms;
    private HeartbeatMode heartbeatMode;
    private boolean cachedInfoExtensionClientState;
    private List<CachedObject> cachedInfoExtensionObjects;
    private List<RequestItemV2> statusRequestV2RequestList;
    private CertificateType selectedClientCertificateType;
    private CertificateType selectedServerCertificateType;
    private byte[] paddingExtensionBytes;
    private byte[] renegotiationInfo;
    private byte[] certificateRequestContext;
    private byte[] signedCertificateTimestamp;
    private CertificateStatusRequestType certificateStatusRequestExtensionRequestType;
    private byte[] certificateStatusRequestExtensionResponderIDList;
    private byte[] certificateStatusRequestExtensionRequestExtension;
    private byte[] secureRemotePasswordExtensionIdentifier;
    private byte[] secureRealTimeProtocolMasterKeyIdentifier;
    private List<SrtpProtectionProfile> clientSupportedSrtpProtectionProfiles;
    private SrtpProtectionProfile selectedSrtpProtectionProfile;
    private UserMappingExtensionHintType userMappingExtensionHintType;
    private List<AuthzDataFormat> clientAuthzDataFormatList;
    private List<AuthzDataFormat> serverAuthzDataFormatList;
    private BigInteger serverEphemeralDhGenerator;
    private BigInteger serverEphemeralDhModulus;
    private BigInteger serverEphemeralDhPrivateKey;
    private BigInteger serverEphemeralDhPublicKey;
    private BigInteger clientEphemeralDhPrivateKey;
    private BigInteger clientEphemeralDhPublicKey;
    private BigInteger srpModulus;
    private BigInteger srpGenerator;
    private BigInteger serverSRPPublicKey;
    private BigInteger serverSRPPrivateKey;
    private BigInteger clientSRPPublicKey;
    private BigInteger clientSRPPrivateKey;
    private byte[] srpServerSalt;
    private byte[] srpPassword;
    private byte[] srpIdentity;
    private byte[] pskKey;
    private byte[] pskIdentity;
    private byte[] pskIdentityHint;
    private NamedGroup selectedGroup;
    private Point clientEphemeralEcPublicKey;
    private Point serverEphemeralEcPublicKey;
    private BigInteger serverEphemeralEcPrivateKey;
    private BigInteger clientEphemeralEcPrivateKey;
    private BigInteger serverEphemeralRsaExportModulus;
    private BigInteger serverEphemeralRsaExportPublicKey;
    private BigInteger serverEphemeralRsaExportPrivateKey;
    private List<NamedGroup> clientNamedGroupsList;
    private List<NamedGroup> serverNamedGroupsList;
    private List<ECPointFormat> clientPointFormatsList;
    private List<ECPointFormat> serverPointFormatsList;
    private boolean receivedFatalAlert = false;
    private boolean receivedMessageWithWrongTls13KeyType = false;
    private List<ClientCertificateType> clientCertificateTypes;
    private byte[] distinguishedNames;
    private ProtocolVersion lastRecordVersion;
    private List<SNIEntry> clientSNIEntryList;
    private List<KeyShareStoreEntry> clientKeyShareStoreEntryList;
    private KeyShareStoreEntry serverKeyShareStoreEntry;
    private GOSTCurve selectedGostCurve;
    private Tls13KeySetType activeClientKeySetType = Tls13KeySetType.NONE;
    private Tls13KeySetType activeServerKeySetType = Tls13KeySetType.NONE;
    private Set<Integer> dtlsReceivedHandshakeMessageSequences;
    private Set<Integer> dtlsReceivedChangeCipherSpecEpochs;
    private List<ProtocolVersion> clientSupportedProtocolVersions;
    private TokenBindingVersion tokenBindingVersion;
    private List<TokenBindingKeyParameters> tokenBindingKeyParameters;
    private boolean tokenBindingNegotiatedSuccessfully = false;
    private List<String> proposedAlpnProtocols;
    private String selectedAlpnProtocol;
    private List<CertificateType> certificateTypeClientDesiredTypes;
    private List<CertificateType> serverCertificateTypeDesiredTypes;
    private List<CertificateType> clientCertificateTypeDesiredTypes;
    private List<TrustedAuthority> trustedCaIndicationExtensionCas;
    private SignatureAndHashAlgorithm selectedSignatureAndHashAlgorithm;
    private PRFAlgorithm prfAlgorithm;
    private ProtocolVersion highestProtocolVersion;
    private Boolean clientAuthentication;
    private String clientPWDUsername;
    private byte[] serverPWDSalt;
    private Point pwdPasswordElement;
    private BigInteger clientPWDPrivate;
    private BigInteger serverPWDPrivate;
    private BigInteger serverPWDScalar;
    private Point serverPWDElement;
    private byte[] lastHandledApplicationMessageData;
    private byte[] lastClientVerifyData;
    private byte[] lastServerVerifyData;
    private byte[] lastClientHello;
    private Random random;
    private LinkedList<ProtocolMessage> messageBuffer;
    private LinkedList<Record> recordBuffer;
    private LinkedList<DtlsHandshakeMessageFragment> fragmentBuffer;
    private final EnumSet<ExtensionType> proposedExtensionSet = EnumSet.noneOf(ExtensionType.class);
    private final EnumSet<ExtensionType> negotiatedExtensionSet = EnumSet.noneOf(ExtensionType.class);
    private boolean secureRenegotiation = false;
    private boolean useExtendedMasterSecret;
    private boolean receivedTransportHandlerException = false;
    private boolean reversePrepareAfterParse = false;
    private EchConfig echConfig;
    private ClientHelloMessage innerClientHello;
    private EncryptedClientHelloMessage outerClientHello;
    private boolean supportsECH;
    private KeyShareEntry echClientKeyShareEntry;
    private KeyShareEntry echServerKeyShareEntry;
    private byte[] esniClientNonce;
    private byte[] esniServerNonce;
    private byte[] esniRecordBytes;
    private EsniDnsKeyRecordVersion esniRecordVersion;
    private byte[] esniRecordChecksum;
    private byte[] publicName;
    private List<KeyShareStoreEntry> esniServerKeyShareEntries;
    private List<CipherSuite> esniServerCipherSuites;
    private Integer esniPaddedLength;
    private Long esniNotBefore;
    private Long esniNotAfter;
    private MaxFragmentLength maxFragmentLength;
    private Integer outboundRecordSizeLimit;
    private Integer inboundRecordSizeLimit;
    private Integer peerReceiveLimit;
    private List<byte[]> writeConnectionIds = new ArrayList<byte[]>();
    private Integer writeConnectionIdIndex;
    private List<byte[]> readConnectionIDs = new ArrayList<byte[]>();
    private Integer readConnectionIdIndex;
    private Integer numberOfRequestedConnectionIds;
    private List<RecordNumber> dtls13AcknowledgedRecords;
    private List<RecordNumber> dtls13ReceivedAcknowledgedRecords;
    private X509Context clientX509Context;
    private X509Context serverX509Context;

    public TlsContext(Context context) {
        super(context);
        X509CertificateConfig certConfig = context.getConfig().getCertificateChainConfig().get(0);
        this.clientX509Context = new X509Context(certConfig);
        this.serverX509Context = new X509Context(certConfig);
        context.setTlsContext(this);
        this.init();
    }

    public List<SrtpProtectionProfile> getClientSupportedSrtpProtectionProfiles() {
        return this.clientSupportedSrtpProtectionProfiles;
    }

    public void setClientSupportedSrtpProtectionProfiles(List<SrtpProtectionProfile> clientSupportedSrtpProtectionProfiles) {
        this.clientSupportedSrtpProtectionProfiles = clientSupportedSrtpProtectionProfiles;
    }

    public SrtpProtectionProfile getSelectedSrtpProtectionProfile() {
        return this.selectedSrtpProtectionProfile;
    }

    public void setSelectedSrtpProtectionProfile(SrtpProtectionProfile selectedSrtpProtectionProfile) {
        this.selectedSrtpProtectionProfile = selectedSrtpProtectionProfile;
    }

    public void resetTalkingX509Context() {
        if (this.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.clientX509Context = new X509Context();
        } else {
            this.serverX509Context = new X509Context();
        }
    }

    public X509Context getTalkingX509Context() {
        if (this.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            return this.clientX509Context;
        }
        return this.serverX509Context;
    }

    public X509Context getPeerX509Context() {
        if (this.getTalkingConnectionEndType() != ConnectionEndType.CLIENT) {
            return this.clientX509Context;
        }
        return this.serverX509Context;
    }

    public void setTalkingX509Context(X509Context context) {
        if (this.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
            this.clientX509Context = context;
        } else {
            this.serverX509Context = context;
        }
    }

    public X509Context getClientX509Context() {
        return this.clientX509Context;
    }

    public void setClientX509Context(X509Context clientX509Context) {
        this.clientX509Context = clientX509Context;
    }

    public X509Context getServerX509Context() {
        return this.serverX509Context;
    }

    public void setServerX509Context(X509Context serverX509Context) {
        this.serverX509Context = serverX509Context;
    }

    public void init() {
        this.digest = new MessageDigestCollector();
        this.sessionList = new LinkedList<Session>();
        this.random = this.getConfig().isStealthMode() != false ? new Random() : new Random(0L);
        this.messageBuffer = new LinkedList();
        this.recordBuffer = new LinkedList();
        this.fragmentBuffer = new LinkedList();
        this.dtlsReceivedHandshakeMessageSequences = new HashSet<Integer>();
        this.dtlsReceivedChangeCipherSpecEpochs = new HashSet<Integer>();
        this.readConnectionIdIndex = 0;
        this.writeConnectionIdIndex = 0;
        this.keylogfile = new Keylogfile(this);
    }

    @Override
    public Chooser getChooser() {
        return this.getContext().getChooser();
    }

    public CertificateType getSelectedClientCertificateType() {
        return this.selectedClientCertificateType;
    }

    public void setSelectedClientCertificateType(CertificateType selectedClientCertificateType) {
        this.selectedClientCertificateType = selectedClientCertificateType;
    }

    public CertificateType getSelectedServerCertificateType() {
        return this.selectedServerCertificateType;
    }

    public void setSelectedServerCertificateType(CertificateType selectedServerCertificateType) {
        this.selectedServerCertificateType = selectedServerCertificateType;
    }

    public boolean isReversePrepareAfterParse() {
        return this.reversePrepareAfterParse;
    }

    public void setReversePrepareAfterParse(boolean reversePrepareAfterParse) {
        this.reversePrepareAfterParse = reversePrepareAfterParse;
    }

    public LinkedList<ProtocolMessage> getMessageBuffer() {
        return this.messageBuffer;
    }

    public void setMessageBuffer(LinkedList<ProtocolMessage> messageBuffer) {
        this.messageBuffer = messageBuffer;
    }

    public LinkedList<Record> getRecordBuffer() {
        return this.recordBuffer;
    }

    public void setRecordBuffer(LinkedList<Record> recordBuffer) {
        this.recordBuffer = recordBuffer;
    }

    public LinkedList<DtlsHandshakeMessageFragment> getFragmentBuffer() {
        return this.fragmentBuffer;
    }

    public void setFragmentBuffer(LinkedList<DtlsHandshakeMessageFragment> fragmentBuffer) {
        this.fragmentBuffer = fragmentBuffer;
    }

    public Session getIdSession(byte[] sessionId) {
        for (Session session : this.sessionList) {
            if (!session.isIdSession() || !Arrays.equals(((IdSession)session).getId(), sessionId)) continue;
            return session;
        }
        return null;
    }

    public boolean hasSession(byte[] sessionId) {
        return this.getIdSession(sessionId) != null;
    }

    public byte[] getLatestSessionTicket() {
        for (int i = this.sessionList.size() - 1; i >= 0; --i) {
            Session session = this.sessionList.get(i);
            if (!session.isTicketSession()) continue;
            return ((TicketSession)session).getTicket();
        }
        return null;
    }

    public void addNewSession(Session session) {
        this.sessionList.add(session);
    }

    public List<Session> getSessionList() {
        return this.sessionList;
    }

    public void setSessionList(List<Session> sessionList) {
        this.sessionList = sessionList;
    }

    public byte[] getLastClientVerifyData() {
        return this.lastClientVerifyData;
    }

    public void setLastClientVerifyData(byte[] lastClientVerifyData) {
        this.lastClientVerifyData = lastClientVerifyData;
    }

    public byte[] getLastServerVerifyData() {
        return this.lastServerVerifyData;
    }

    public void setLastServerVerifyData(byte[] lastServerVerifyData) {
        this.lastServerVerifyData = lastServerVerifyData;
    }

    public List<CertificateType> getCertificateTypeClientDesiredTypes() {
        return this.certificateTypeClientDesiredTypes;
    }

    public void setCertificateTypeClientDesiredTypes(List<CertificateType> certificateTypeClientDesiredTypes) {
        this.certificateTypeClientDesiredTypes = certificateTypeClientDesiredTypes;
    }

    public boolean isSecureRenegotiation() {
        return this.secureRenegotiation;
    }

    public void setSecureRenegotiation(boolean secureRenegotiation) {
        this.secureRenegotiation = secureRenegotiation;
    }

    public List<ProtocolVersion> getClientSupportedProtocolVersions() {
        return this.clientSupportedProtocolVersions;
    }

    public void setClientSupportedProtocolVersions(List<ProtocolVersion> clientSupportedProtocolVersions) {
        this.clientSupportedProtocolVersions = clientSupportedProtocolVersions;
    }

    public void setClientSupportedProtocolVersions(ProtocolVersion ... clientSupportedProtocolVersions) {
        this.clientSupportedProtocolVersions = new ArrayList<ProtocolVersion>(Arrays.asList(clientSupportedProtocolVersions));
    }

    public NamedGroup getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(NamedGroup selectedCurve) {
        this.selectedGroup = selectedCurve;
    }

    public BigInteger getSRPGenerator() {
        return this.srpGenerator;
    }

    public void setSRPGenerator(BigInteger srpGenerator) {
        this.srpGenerator = srpGenerator;
    }

    public BigInteger getSRPModulus() {
        return this.srpModulus;
    }

    public void setSRPModulus(BigInteger srpModulus) {
        this.srpModulus = srpModulus;
    }

    public byte[] getPSKIdentity() {
        return this.pskIdentity;
    }

    public void setPSKIdentity(byte[] pskIdentity) {
        this.pskIdentity = pskIdentity;
    }

    public byte[] getPSKIdentityHint() {
        return this.pskIdentityHint;
    }

    public void setPSKIdentityHint(byte[] pskIdentityHint) {
        this.pskIdentityHint = pskIdentityHint;
    }

    public BigInteger getServerSRPPublicKey() {
        return this.serverSRPPublicKey;
    }

    public void setServerSRPPublicKey(BigInteger serverSRPPublicKey) {
        this.serverSRPPublicKey = serverSRPPublicKey;
    }

    public BigInteger getServerSRPPrivateKey() {
        return this.serverSRPPrivateKey;
    }

    public void setServerSRPPrivateKey(BigInteger serverSRPPrivateKey) {
        this.serverSRPPrivateKey = serverSRPPrivateKey;
    }

    public BigInteger getClientSRPPublicKey() {
        return this.clientSRPPublicKey;
    }

    public void setClientSRPPublicKey(BigInteger clientSRPPublicKey) {
        this.clientSRPPublicKey = clientSRPPublicKey;
    }

    public BigInteger getClientSRPPrivateKey() {
        return this.clientSRPPrivateKey;
    }

    public void setClientSRPPrivateKey(BigInteger clientSRPPrivateKey) {
        this.clientSRPPrivateKey = clientSRPPrivateKey;
    }

    public byte[] getSRPServerSalt() {
        return this.srpServerSalt;
    }

    public void setSRPServerSalt(byte[] srpServerSalt) {
        this.srpServerSalt = srpServerSalt;
    }

    public byte[] getPSKKey() {
        return this.pskKey;
    }

    public void setPSKKey(byte[] pskKey) {
        this.pskKey = pskKey;
    }

    public byte[] getSRPPassword() {
        return this.srpPassword;
    }

    public void setSRPPassword(byte[] srpPassword) {
        this.srpPassword = srpPassword;
    }

    public byte[] getSRPIdentity() {
        return this.srpIdentity;
    }

    public void setSRPIdentity(byte[] srpIdentity) {
        this.srpIdentity = srpIdentity;
    }

    public GOSTCurve getServerGost01Curve() {
        return this.selectedGostCurve;
    }

    public void setServerGost01Curve(GOSTCurve serverGost01Curve) {
        this.selectedGostCurve = serverGost01Curve;
    }

    public SignatureAndHashAlgorithm getSelectedSignatureAndHashAlgorithm() {
        return this.selectedSignatureAndHashAlgorithm;
    }

    public void setSelectedSignatureAndHashAlgorithm(SignatureAndHashAlgorithm selectedSignatureAndHashAlgorithm) {
        this.selectedSignatureAndHashAlgorithm = selectedSignatureAndHashAlgorithm;
    }

    public List<NamedGroup> getClientNamedGroupsList() {
        return this.clientNamedGroupsList;
    }

    public void setClientNamedGroupsList(List<NamedGroup> clientNamedGroupsList) {
        this.clientNamedGroupsList = clientNamedGroupsList;
    }

    public void setClientNamedGroupsList(NamedGroup ... clientNamedGroupsList) {
        this.clientNamedGroupsList = new ArrayList<NamedGroup>(Arrays.asList(clientNamedGroupsList));
    }

    public List<NamedGroup> getServerNamedGroupsList() {
        return this.serverNamedGroupsList;
    }

    public void setServerNamedGroupsList(List<NamedGroup> serverNamedGroupsList) {
        this.serverNamedGroupsList = serverNamedGroupsList;
    }

    public void setServerNamedGroupsList(NamedGroup ... serverNamedGroupsList) {
        this.serverNamedGroupsList = new ArrayList<NamedGroup>(Arrays.asList(serverNamedGroupsList));
    }

    public List<ECPointFormat> getServerPointFormatsList() {
        return this.serverPointFormatsList;
    }

    public void setServerPointFormatsList(List<ECPointFormat> serverPointFormatsList) {
        this.serverPointFormatsList = serverPointFormatsList;
    }

    public void setServerPointFormatsList(ECPointFormat ... serverPointFormatsList) {
        this.serverPointFormatsList = new ArrayList<ECPointFormat>(Arrays.asList(serverPointFormatsList));
    }

    public List<SignatureAndHashAlgorithm> getClientSupportedSignatureAndHashAlgorithms() {
        return this.clientSupportedSignatureAndHashAlgorithms;
    }

    public void setClientSupportedSignatureAndHashAlgorithms(List<SignatureAndHashAlgorithm> clientSupportedSignatureAndHashAlgorithms) {
        this.clientSupportedSignatureAndHashAlgorithms = clientSupportedSignatureAndHashAlgorithms;
    }

    public void setClientSupportedSignatureAndHashAlgorithms(SignatureAndHashAlgorithm ... clientSupportedSignatureAndHashAlgorithms) {
        this.clientSupportedSignatureAndHashAlgorithms = new ArrayList<SignatureAndHashAlgorithm>(Arrays.asList(clientSupportedSignatureAndHashAlgorithms));
    }

    public List<SignatureAndHashAlgorithm> getClientSupportedCertificateSignAlgorithms() {
        return this.clientSupportedCertificateSignAlgorithms;
    }

    public void setClientSupportedCertificateSignAlgorithms(List<SignatureAndHashAlgorithm> clientSupportedCertificateSignAlgorithms) {
        this.clientSupportedCertificateSignAlgorithms = clientSupportedCertificateSignAlgorithms;
    }

    public void setClientSupportedCertificateSignAlgorithms(SignatureAndHashAlgorithm ... clientSupportedCertificateSignAlgorithms) {
        this.clientSupportedCertificateSignAlgorithms = new ArrayList<SignatureAndHashAlgorithm>(Arrays.asList(clientSupportedCertificateSignAlgorithms));
    }

    public List<SNIEntry> getClientSNIEntryList() {
        return this.clientSNIEntryList;
    }

    public void setClientSNIEntryList(List<SNIEntry> clientSNIEntryList) {
        this.clientSNIEntryList = clientSNIEntryList;
    }

    public void setClientSNIEntryList(SNIEntry ... clientSNIEntryList) {
        this.clientSNIEntryList = new ArrayList<SNIEntry>(Arrays.asList(clientSNIEntryList));
    }

    public ProtocolVersion getLastRecordVersion() {
        return this.lastRecordVersion;
    }

    public void setLastRecordVersion(ProtocolVersion lastRecordVersion) {
        this.lastRecordVersion = lastRecordVersion;
    }

    public byte[] getDistinguishedNames() {
        return this.distinguishedNames;
    }

    public void setDistinguishedNames(byte[] distinguishedNames) {
        this.distinguishedNames = distinguishedNames;
    }

    public List<ClientCertificateType> getClientCertificateTypes() {
        return this.clientCertificateTypes;
    }

    public void setClientCertificateTypes(List<ClientCertificateType> clientCertificateTypes) {
        this.clientCertificateTypes = clientCertificateTypes;
    }

    public void setClientCertificateTypes(ClientCertificateType ... clientCertificateTypes) {
        this.clientCertificateTypes = new ArrayList<ClientCertificateType>(Arrays.asList(clientCertificateTypes));
    }

    public boolean isReceivedFatalAlert() {
        return this.receivedFatalAlert;
    }

    public void setReceivedFatalAlert(boolean receivedFatalAlert) {
        this.receivedFatalAlert = receivedFatalAlert;
    }

    public List<ECPointFormat> getClientPointFormatsList() {
        return this.clientPointFormatsList;
    }

    public void setClientPointFormatsList(List<ECPointFormat> clientPointFormatsList) {
        this.clientPointFormatsList = clientPointFormatsList;
    }

    public void setClientPointFormatsList(ECPointFormat ... clientPointFormatsList) {
        this.clientPointFormatsList = new ArrayList<ECPointFormat>(Arrays.asList(clientPointFormatsList));
    }

    public MaxFragmentLength getMaxFragmentLength() {
        return this.maxFragmentLength;
    }

    public void setMaxFragmentLength(MaxFragmentLength maxFragmentLength) {
        this.maxFragmentLength = maxFragmentLength;
    }

    public HeartbeatMode getHeartbeatMode() {
        return this.heartbeatMode;
    }

    public void setHeartbeatMode(HeartbeatMode heartbeatMode) {
        this.heartbeatMode = heartbeatMode;
    }

    public byte[] getPaddingExtensionBytes() {
        return this.paddingExtensionBytes;
    }

    public void setPaddingExtensionBytes(byte[] paddingExtensionBytes) {
        this.paddingExtensionBytes = paddingExtensionBytes;
    }

    public List<CompressionMethod> getClientSupportedCompressions() {
        return this.clientSupportedCompressions;
    }

    public void setClientSupportedCompressions(List<CompressionMethod> clientSupportedCompressions) {
        this.clientSupportedCompressions = clientSupportedCompressions;
    }

    public void setClientSupportedCompressions(CompressionMethod ... clientSupportedCompressions) {
        this.clientSupportedCompressions = new ArrayList<CompressionMethod>(Arrays.asList(clientSupportedCompressions));
    }

    public void addDtlsReceivedHandshakeMessageSequences(int sequence) {
        this.dtlsReceivedHandshakeMessageSequences.add(sequence);
    }

    public Set<Integer> getDtlsReceivedHandshakeMessageSequences() {
        return this.dtlsReceivedHandshakeMessageSequences;
    }

    public boolean addDtlsReceivedChangeCipherSpecEpochs(int epoch) {
        return this.dtlsReceivedChangeCipherSpecEpochs.add(epoch);
    }

    public Set<Integer> getDtlsReceivedChangeCipherSpecEpochs() {
        return this.dtlsReceivedChangeCipherSpecEpochs;
    }

    public List<CipherSuite> getClientSupportedCipherSuites() {
        return this.clientSupportedCipherSuites;
    }

    public void setClientSupportedCipherSuites(List<CipherSuite> clientSupportedCipherSuites) {
        this.clientSupportedCipherSuites = clientSupportedCipherSuites;
    }

    public void setClientSupportedCipherSuites(CipherSuite ... clientSupportedCipherSuites) {
        this.clientSupportedCipherSuites = new ArrayList<CipherSuite>(Arrays.asList(clientSupportedCipherSuites));
    }

    public List<SignatureAndHashAlgorithm> getServerSupportedSignatureAndHashAlgorithms() {
        return this.serverSupportedSignatureAndHashAlgorithms;
    }

    public void setServerSupportedSignatureAndHashAlgorithms(List<SignatureAndHashAlgorithm> serverSupportedSignatureAndHashAlgorithms) {
        this.serverSupportedSignatureAndHashAlgorithms = serverSupportedSignatureAndHashAlgorithms;
    }

    public void setServerSupportedSignatureAndHashAlgorithms(SignatureAndHashAlgorithm ... serverSupportedSignatureAndHashAlgorithms) {
        this.serverSupportedSignatureAndHashAlgorithms = new ArrayList<SignatureAndHashAlgorithm>(Arrays.asList(serverSupportedSignatureAndHashAlgorithms));
    }

    public List<SignatureAndHashAlgorithm> getServerSupportedCertificateSignAlgorithms() {
        return this.serverSupportedCertificateSignAlgorithms;
    }

    public void setServerSupportedSignatureAlgorithmsCert(List<SignatureAndHashAlgorithm> serverSupportedCertificateSignAlgorithms) {
        this.serverSupportedCertificateSignAlgorithms = serverSupportedCertificateSignAlgorithms;
    }

    public void setServerSupportedSignatureAlgorithmsCert(SignatureAndHashAlgorithm ... serverSupportedCertificateSignAlgorithms) {
        this.serverSupportedCertificateSignAlgorithms = new ArrayList<SignatureAndHashAlgorithm>(Arrays.asList(serverSupportedCertificateSignAlgorithms));
    }

    public ProtocolVersion getSelectedProtocolVersion() {
        return this.selectedProtocolVersion;
    }

    public void setSelectedProtocolVersion(ProtocolVersion selectedProtocolVersion) {
        this.selectedProtocolVersion = selectedProtocolVersion;
    }

    public ProtocolVersion getHighestClientProtocolVersion() {
        return this.highestClientProtocolVersion;
    }

    public void setHighestClientProtocolVersion(ProtocolVersion highestClientProtocolVersion) {
        this.highestClientProtocolVersion = highestClientProtocolVersion;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }

    public byte[] getResumptionMasterSecret() {
        return this.resumptionMasterSecret;
    }

    public CipherSuite getSelectedCipherSuite() {
        return this.selectedCipherSuite;
    }

    public SSL2CipherSuite getSSL2CipherSuite() {
        return this.ssl2CipherSuite;
    }

    public void setMasterSecret(byte[] masterSecret) {
        this.keylogfile.writeKey("CLIENT_RANDOM", masterSecret);
        this.masterSecret = masterSecret;
    }

    public byte[] setResumptionMasterSecret(byte[] resumptionMasterSecret) {
        this.resumptionMasterSecret = resumptionMasterSecret;
        return resumptionMasterSecret;
    }

    public void setSelectedCipherSuite(CipherSuite selectedCipherSuite) {
        this.selectedCipherSuite = selectedCipherSuite;
    }

    public void setSSL2CipherSuite(SSL2CipherSuite ssl2CipherSuite) {
        this.ssl2CipherSuite = ssl2CipherSuite;
    }

    public byte[] getClientServerRandom() {
        return DataConverter.concatenate((byte[][])new byte[][]{this.clientRandom, this.serverRandom});
    }

    public byte[] getClearKey() {
        return this.clearKey;
    }

    public void setClearKey(byte[] clearKey) {
        this.clearKey = clearKey;
    }

    public byte[] getPreMasterSecret() {
        return this.preMasterSecret;
    }

    public void setPreMasterSecret(byte[] preMasterSecret) {
        this.keylogfile.writeKey("PMS_CLIENT_RANDOM", preMasterSecret);
        this.preMasterSecret = preMasterSecret;
    }

    public byte[] getClientExtendedRandom() {
        return this.clientExtendedRandom;
    }

    public void setClientExtendedRandom(byte[] clientExtendedRandom) {
        this.clientExtendedRandom = clientExtendedRandom;
    }

    public byte[] getServerExtendedRandom() {
        return this.serverExtendedRandom;
    }

    public void setServerExtendedRandom(byte[] serverExtendedRandom) {
        this.serverExtendedRandom = serverExtendedRandom;
    }

    public byte[] getClientRandom() {
        return this.clientRandom;
    }

    public void setClientRandom(byte[] clientRandom) {
        this.clientRandom = clientRandom;
    }

    public byte[] getServerRandom() {
        return this.serverRandom;
    }

    public void setServerRandom(byte[] serverRandom) {
        this.serverRandom = serverRandom;
    }

    public CompressionMethod getSelectedCompressionMethod() {
        return this.selectedCompressionMethod;
    }

    public void setSelectedCompressionMethod(CompressionMethod selectedCompressionMethod) {
        this.selectedCompressionMethod = selectedCompressionMethod;
    }

    public byte[] getServerSessionId() {
        return this.serverSessionId;
    }

    public void setServerSessionId(byte[] serverSessionId) {
        this.serverSessionId = serverSessionId;
    }

    public byte[] getClientSessionId() {
        return this.clientSessionId;
    }

    public void setClientSessionId(byte[] clientSessionId) {
        this.clientSessionId = clientSessionId;
    }

    public byte[] getSSL2Iv() {
        return this.ssl2Iv;
    }

    public void setSSL2Iv(byte[] ssl2Iv) {
        this.ssl2Iv = ssl2Iv;
    }

    public X509CertificateChain getServerCertificateChain() {
        return this.serverCertificateChain;
    }

    public void setServerCertificateChain(X509CertificateChain serverCertificateChain) {
        this.serverCertificateChain = serverCertificateChain;
    }

    public X509CertificateChain getClientCertificateChain() {
        return this.clientCertificateChain;
    }

    public void setClientCertificateChain(X509CertificateChain clientCertificateChain) {
        this.clientCertificateChain = clientCertificateChain;
    }

    public MessageDigestCollector getDigest() {
        return this.digest;
    }

    public void setDigest(MessageDigestCollector digest) {
        this.digest = digest;
    }

    public byte[] getDtlsCookie() {
        return this.dtlsCookie;
    }

    public void setDtlsCookie(byte[] dtlsCookie) {
        this.dtlsCookie = dtlsCookie;
    }

    public DtlsFragmentLayer getDtlsFragmentLayer() {
        return (DtlsFragmentLayer)this.getContext().getLayerStack().getLayer(DtlsFragmentLayer.class);
    }

    public RecordLayer getRecordLayer() {
        return (RecordLayer)this.getContext().getLayerStack().getLayer(RecordLayer.class);
    }

    public PRFAlgorithm getPrfAlgorithm() {
        return this.prfAlgorithm;
    }

    public void setPrfAlgorithm(PRFAlgorithm prfAlgorithm) {
        this.prfAlgorithm = prfAlgorithm;
    }

    public byte[] getClientHandshakeTrafficSecret() {
        return this.clientHandshakeTrafficSecret;
    }

    public void setClientHandshakeTrafficSecret(byte[] clientHandshakeTrafficSecret) {
        this.keylogfile.writeKey("CLIENT_HANDSHAKE_TRAFFIC_SECRET", clientHandshakeTrafficSecret);
        this.clientHandshakeTrafficSecret = clientHandshakeTrafficSecret;
    }

    public byte[] getServerHandshakeTrafficSecret() {
        return this.serverHandshakeTrafficSecret;
    }

    public void setServerHandshakeTrafficSecret(byte[] serverHandshakeTrafficSecret) {
        this.keylogfile.writeKey("SERVER_HANDSHAKE_TRAFFIC_SECRET", serverHandshakeTrafficSecret);
        this.serverHandshakeTrafficSecret = serverHandshakeTrafficSecret;
    }

    public byte[] getClientApplicationTrafficSecret() {
        return this.clientApplicationTrafficSecret;
    }

    public void setClientApplicationTrafficSecret(byte[] clientApplicationTrafficSecret) {
        this.keylogfile.writeKey("CLIENT_TRAFFIC_SECRET_0", clientApplicationTrafficSecret);
        this.clientApplicationTrafficSecret = clientApplicationTrafficSecret;
    }

    public byte[] getServerApplicationTrafficSecret() {
        return this.serverApplicationTrafficSecret;
    }

    public void setServerApplicationTrafficSecret(byte[] serverApplicationTrafficSecret) {
        this.keylogfile.writeKey("SERVER_TRAFFIC_SECRET_0", serverApplicationTrafficSecret);
        this.serverApplicationTrafficSecret = serverApplicationTrafficSecret;
    }

    public byte[] getHandshakeSecret() {
        return this.handshakeSecret;
    }

    public void setHandshakeSecret(byte[] handshakeSecret) {
        this.handshakeSecret = handshakeSecret;
    }

    public List<KeyShareStoreEntry> getClientKeyShareStoreEntryList() {
        return this.clientKeyShareStoreEntryList;
    }

    public void setClientKeyShareStoreEntryList(List<KeyShareStoreEntry> clientKeyShareStoreEntryList) {
        this.clientKeyShareStoreEntryList = clientKeyShareStoreEntryList;
    }

    public void setClientKSEntryList(KeyShareStoreEntry ... clientKSEntryList) {
        this.clientKeyShareStoreEntryList = new ArrayList<KeyShareStoreEntry>(Arrays.asList(clientKSEntryList));
    }

    public KeyShareStoreEntry getServerKeyShareStoreEntry() {
        return this.serverKeyShareStoreEntry;
    }

    public void setServerKeyShareStoreEntry(KeyShareStoreEntry serverKeyShareStoreEntry) {
        this.serverKeyShareStoreEntry = serverKeyShareStoreEntry;
    }

    public byte[] getSignedCertificateTimestamp() {
        return this.signedCertificateTimestamp;
    }

    public void setSignedCertificateTimestamp(byte[] signedCertificateTimestamp) {
        this.signedCertificateTimestamp = signedCertificateTimestamp;
    }

    public byte[] getRenegotiationInfo() {
        return this.renegotiationInfo;
    }

    public void setRenegotiationInfo(byte[] renegotiationInfo) {
        this.renegotiationInfo = renegotiationInfo;
    }

    public TokenBindingVersion getTokenBindingVersion() {
        return this.tokenBindingVersion;
    }

    public void setTokenBindingVersion(TokenBindingVersion tokenBindingVersion) {
        this.tokenBindingVersion = tokenBindingVersion;
    }

    public void setTokenBindingKeyParameters(TokenBindingKeyParameters ... tokenBindingKeyParameters) {
        this.tokenBindingKeyParameters = new ArrayList<TokenBindingKeyParameters>(Arrays.asList(tokenBindingKeyParameters));
    }

    public void setTokenBindingKeyParameters(List<TokenBindingKeyParameters> tokenBindingKeyParameters) {
        this.tokenBindingKeyParameters = tokenBindingKeyParameters;
    }

    public List<TokenBindingKeyParameters> getTokenBindingKeyParameters() {
        return this.tokenBindingKeyParameters;
    }

    public void setTokenBindingNegotiatedSuccessfully(boolean tokenBindingNegotiated) {
        this.tokenBindingNegotiatedSuccessfully = tokenBindingNegotiated;
    }

    public boolean isTokenBindingNegotiatedSuccessfully() {
        return this.tokenBindingNegotiatedSuccessfully;
    }

    public CertificateStatusRequestType getCertificateStatusRequestExtensionRequestType() {
        return this.certificateStatusRequestExtensionRequestType;
    }

    public void setCertificateStatusRequestExtensionRequestType(CertificateStatusRequestType certificateStatusRequestExtensionRequestType) {
        this.certificateStatusRequestExtensionRequestType = certificateStatusRequestExtensionRequestType;
    }

    public byte[] getCertificateStatusRequestExtensionResponderIDList() {
        return this.certificateStatusRequestExtensionResponderIDList;
    }

    public void setCertificateStatusRequestExtensionResponderIDList(byte[] certificateStatusRequestExtensionResponderIDList) {
        this.certificateStatusRequestExtensionResponderIDList = certificateStatusRequestExtensionResponderIDList;
    }

    public byte[] getCertificateStatusRequestExtensionRequestExtension() {
        return this.certificateStatusRequestExtensionRequestExtension;
    }

    public void setCertificateStatusRequestExtensionRequestExtension(byte[] certificateStatusRequestExtensionRequestExtension) {
        this.certificateStatusRequestExtensionRequestExtension = certificateStatusRequestExtensionRequestExtension;
    }

    public String getSelectedAlpnProtocol() {
        return this.selectedAlpnProtocol;
    }

    public void setSelectedAlpnProtocol(String selectedAlpnProtocol) {
        this.selectedAlpnProtocol = selectedAlpnProtocol;
    }

    public List<String> getProposedAlpnProtocols() {
        return this.proposedAlpnProtocols;
    }

    public void setProposedAlpnProtocols(List<String> proposedAlpnProtocols) {
        this.proposedAlpnProtocols = proposedAlpnProtocols;
    }

    public byte[] getSecureRemotePasswordExtensionIdentifier() {
        return this.secureRemotePasswordExtensionIdentifier;
    }

    public void setSecureRemotePasswordExtensionIdentifier(byte[] secureRemotePasswordExtensionIdentifier) {
        this.secureRemotePasswordExtensionIdentifier = secureRemotePasswordExtensionIdentifier;
    }

    public byte[] getSecureRealTimeProtocolMasterKeyIdentifier() {
        return this.secureRealTimeProtocolMasterKeyIdentifier;
    }

    public void setSecureRealTimeProtocolMasterKeyIdentifier(byte[] secureRealTimeProtocolMasterKeyIdentifier) {
        this.secureRealTimeProtocolMasterKeyIdentifier = secureRealTimeProtocolMasterKeyIdentifier;
    }

    public UserMappingExtensionHintType getUserMappingExtensionHintType() {
        return this.userMappingExtensionHintType;
    }

    public void setUserMappingExtensionHintType(UserMappingExtensionHintType userMappingExtensionHintType) {
        this.userMappingExtensionHintType = userMappingExtensionHintType;
    }

    public List<CertificateType> getCertificateTypeDesiredTypes() {
        return this.certificateTypeClientDesiredTypes;
    }

    public void setCertificateTypeDesiredTypes(List<CertificateType> certificateTypeDesiredTypes) {
        this.certificateTypeClientDesiredTypes = certificateTypeDesiredTypes;
    }

    public List<AuthzDataFormat> getClientAuthzDataFormatList() {
        return this.clientAuthzDataFormatList;
    }

    public void setClientAuthzDataFormatList(List<AuthzDataFormat> clientAuthzDataFormatList) {
        this.clientAuthzDataFormatList = clientAuthzDataFormatList;
    }

    public List<AuthzDataFormat> getServerAuthzDataFormatList() {
        return this.serverAuthzDataFormatList;
    }

    public void setServerAuthzDataFormatList(List<AuthzDataFormat> serverAuthzDataFormatList) {
        this.serverAuthzDataFormatList = serverAuthzDataFormatList;
    }

    public byte[] getCertificateRequestContext() {
        return this.certificateRequestContext;
    }

    public void setCertificateRequestContext(byte[] certificateRequestContext) {
        this.certificateRequestContext = certificateRequestContext;
    }

    public List<CertificateType> getClientCertificateTypeDesiredTypes() {
        return this.clientCertificateTypeDesiredTypes;
    }

    public void setClientCertificateTypeDesiredTypes(List<CertificateType> clientCertificateTypeDesiredTypes) {
        this.clientCertificateTypeDesiredTypes = clientCertificateTypeDesiredTypes;
    }

    public List<CertificateType> getServerCertificateTypeDesiredTypes() {
        return this.serverCertificateTypeDesiredTypes;
    }

    public void setServerCertificateTypeDesiredTypes(List<CertificateType> serverCertificateTypeDesiredTypes) {
        this.serverCertificateTypeDesiredTypes = serverCertificateTypeDesiredTypes;
    }

    public boolean isCachedInfoExtensionClientState() {
        return this.cachedInfoExtensionClientState;
    }

    public void setCachedInfoExtensionClientState(boolean cachedInfoExtensionClientState) {
        this.cachedInfoExtensionClientState = cachedInfoExtensionClientState;
    }

    public List<CachedObject> getCachedInfoExtensionObjects() {
        return this.cachedInfoExtensionObjects;
    }

    public void setCachedInfoExtensionObjects(List<CachedObject> cachedInfoExtensionObjects) {
        this.cachedInfoExtensionObjects = cachedInfoExtensionObjects;
    }

    public List<TrustedAuthority> getTrustedCaIndicationExtensionCas() {
        return this.trustedCaIndicationExtensionCas;
    }

    public void setTrustedCaIndicationExtensionCas(List<TrustedAuthority> trustedCaIndicationExtensionCas) {
        this.trustedCaIndicationExtensionCas = trustedCaIndicationExtensionCas;
    }

    public List<RequestItemV2> getStatusRequestV2RequestList() {
        return this.statusRequestV2RequestList;
    }

    public void setStatusRequestV2RequestList(List<RequestItemV2> statusRequestV2RequestList) {
        this.statusRequestV2RequestList = statusRequestV2RequestList;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public BadRandom getBadSecureRandom() {
        return new BadRandom(this.getRandom(), null);
    }

    @Override
    public Config getConfig() {
        return this.getContext().getConfig();
    }

    public ProtocolVersion getHighestProtocolVersion() {
        return this.highestProtocolVersion;
    }

    public void setHighestProtocolVersion(ProtocolVersion highestProtocolVersion) {
        this.highestProtocolVersion = highestProtocolVersion;
    }

    public Boolean isClientAuthentication() {
        return this.clientAuthentication;
    }

    public void setClientAuthentication(Boolean clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
    }

    public byte[] getLastHandledApplicationMessageData() {
        return this.lastHandledApplicationMessageData;
    }

    public void setLastHandledApplicationMessageData(byte[] lastHandledApplicationMessageData) {
        this.lastHandledApplicationMessageData = lastHandledApplicationMessageData;
    }

    public boolean isExtensionProposed(ExtensionType ext) {
        return this.proposedExtensionSet.contains((Object)ext);
    }

    public EnumSet<ExtensionType> getProposedExtensions() {
        return this.proposedExtensionSet;
    }

    public void addProposedExtension(ExtensionType ext) {
        this.proposedExtensionSet.add(ext);
    }

    public boolean isExtensionNegotiated(ExtensionType ext) {
        return this.negotiatedExtensionSet.contains((Object)ext);
    }

    public void addNegotiatedExtension(ExtensionType ext) {
        this.negotiatedExtensionSet.add(ext);
    }

    public EnumSet<ExtensionType> getNegotiatedExtensionSet() {
        return this.negotiatedExtensionSet;
    }

    public boolean isUseExtendedMasterSecret() {
        return this.useExtendedMasterSecret;
    }

    public void setUseExtendedMasterSecret(boolean useExtendedMasterSecret) {
        this.useExtendedMasterSecret = useExtendedMasterSecret;
    }

    public KeySet getkeySetHandshake() {
        return this.keySetHandshake;
    }

    public void setkeySetHandshake(KeySet keySetHandshake) {
        this.keySetHandshake = keySetHandshake;
    }

    public byte[] getClientEarlyTrafficSecret() {
        return this.clientEarlyTrafficSecret;
    }

    public void setClientEarlyTrafficSecret(byte[] clientEarlyTrafficSecret) {
        this.keylogfile.writeKey("CLIENT_EARLY_TRAFFIC_SECRET", clientEarlyTrafficSecret);
        this.clientEarlyTrafficSecret = clientEarlyTrafficSecret;
    }

    public Integer getMaxEarlyDataSize() {
        return this.maxEarlyDataSize;
    }

    public void setMaxEarlyDataSize(Integer maxEarlyDataSize) {
        this.maxEarlyDataSize = maxEarlyDataSize;
    }

    public byte[] getPsk() {
        return this.psk;
    }

    public void setPsk(byte[] psk) {
        this.psk = psk;
    }

    public byte[] getEarlySecret() {
        return this.earlySecret;
    }

    public void setEarlySecret(byte[] earlySecret) {
        this.earlySecret = earlySecret;
    }

    public CipherSuite getEarlyDataCipherSuite() {
        return this.earlyDataCipherSuite;
    }

    public void setEarlyDataCipherSuite(CipherSuite earlyDataCipherSuite) {
        this.earlyDataCipherSuite = earlyDataCipherSuite;
    }

    public byte[] getEarlyDataPSKIdentity() {
        return this.earlyDataPSKIdentity;
    }

    public void setEarlyDataPSKIdentity(byte[] earlyDataPSKIdentity) {
        this.earlyDataPSKIdentity = earlyDataPSKIdentity;
    }

    public int getSelectedIdentityIndex() {
        return this.selectedIdentityIndex;
    }

    public void setSelectedIdentityIndex(int selectedIdentityIndex) {
        this.selectedIdentityIndex = selectedIdentityIndex;
    }

    public List<PskKeyExchangeMode> getClientPskKeyExchangeModes() {
        return this.clientPskKeyExchangeModes;
    }

    public void setClientPskKeyExchangeModes(List<PskKeyExchangeMode> clientPskKeyExchangeModes) {
        this.clientPskKeyExchangeModes = clientPskKeyExchangeModes;
    }

    public List<PskSet> getPskSets() {
        return this.pskSets;
    }

    public void setPskSets(List<PskSet> pskSets) {
        this.pskSets = pskSets;
    }

    public Tls13KeySetType getActiveClientKeySetType() {
        return this.activeClientKeySetType;
    }

    public void setActiveClientKeySetType(Tls13KeySetType activeClientKeySetType) {
        this.activeClientKeySetType = activeClientKeySetType;
    }

    public Tls13KeySetType getActiveServerKeySetType() {
        return this.activeServerKeySetType;
    }

    public void setActiveServerKeySetType(Tls13KeySetType activeServerKeySetType) {
        this.activeServerKeySetType = activeServerKeySetType;
    }

    public Tls13KeySetType getActiveKeySetTypeRead() {
        if (this.getChooser().getConnectionEndType() == ConnectionEndType.SERVER) {
            return this.activeClientKeySetType;
        }
        return this.activeServerKeySetType;
    }

    public Tls13KeySetType getActiveKeySetTypeWrite() {
        if (this.getChooser().getConnectionEndType() == ConnectionEndType.SERVER) {
            return this.activeServerKeySetType;
        }
        return this.activeClientKeySetType;
    }

    public byte[] getEarlyDataPsk() {
        return this.earlyDataPsk;
    }

    public void setEarlyDataPsk(byte[] earlyDataPsk) {
        this.earlyDataPsk = earlyDataPsk;
    }

    public boolean isReceivedTransportHandlerException() {
        return this.receivedTransportHandlerException;
    }

    public void setReceivedTransportHandlerException(boolean receivedTransportHandlerException) {
        this.receivedTransportHandlerException = receivedTransportHandlerException;
    }

    public void setClientPWDUsername(String username) {
        this.clientPWDUsername = username;
    }

    public String getClientPWDUsername() {
        return this.clientPWDUsername;
    }

    public void setServerPWDSalt(byte[] salt) {
        this.serverPWDSalt = salt;
    }

    public byte[] getServerPWDSalt() {
        return this.serverPWDSalt;
    }

    public Point getPwdPasswordElement() {
        return this.pwdPasswordElement;
    }

    public void setPwdPasswordElement(Point pwdPasswordElement) {
        this.pwdPasswordElement = pwdPasswordElement;
    }

    public BigInteger getClientPWDPrivate() {
        return this.clientPWDPrivate;
    }

    public void setClientPWDPrivate(BigInteger clientPWDPrivate) {
        this.clientPWDPrivate = clientPWDPrivate;
    }

    public BigInteger getServerPWDPrivate() {
        return this.serverPWDPrivate;
    }

    public void setServerPWDPrivate(BigInteger serverPWDPrivate) {
        this.serverPWDPrivate = serverPWDPrivate;
    }

    public BigInteger getServerPWDScalar() {
        return this.serverPWDScalar;
    }

    public void setServerPWDScalar(BigInteger serverPWDScalar) {
        this.serverPWDScalar = serverPWDScalar;
    }

    public Point getServerPWDElement() {
        return this.serverPWDElement;
    }

    public void setServerPWDElement(Point serverPWDElement) {
        this.serverPWDElement = serverPWDElement;
    }

    public GOSTCurve getSelectedGostCurve() {
        return this.selectedGostCurve;
    }

    public void setSelectedGostCurve(GOSTCurve selectedGostCurve) {
        this.selectedGostCurve = selectedGostCurve;
    }

    public EchConfig getEchConfig() {
        return this.echConfig;
    }

    public void setEchConfig(EchConfig echConfig) {
        this.echConfig = echConfig;
    }

    public ClientHelloMessage getInnerClientHello() {
        return this.innerClientHello;
    }

    public void setInnerClientHello(ClientHelloMessage innerClientHello) {
        this.innerClientHello = innerClientHello;
    }

    public EncryptedClientHelloMessage getOuterClientHello() {
        return this.outerClientHello;
    }

    public void setOuterClientHello(EncryptedClientHelloMessage outerClientHello) {
        this.outerClientHello = outerClientHello;
    }

    public boolean isSupportsECH() {
        return this.supportsECH;
    }

    public void setSupportsECH(boolean supportsECH) {
        this.supportsECH = supportsECH;
    }

    public KeyShareEntry getEchClientKeyShareEntry() {
        return this.echClientKeyShareEntry;
    }

    public void setEchClientKeyShareEntry(KeyShareEntry echClientKeyShareEntry) {
        this.echClientKeyShareEntry = echClientKeyShareEntry;
    }

    public KeyShareEntry getEchServerKeyShareEntry() {
        return this.echServerKeyShareEntry;
    }

    public void setEchServerKeyShareEntry(KeyShareEntry echServerKeyShareEntry) {
        this.echServerKeyShareEntry = echServerKeyShareEntry;
    }

    public byte[] getEsniClientNonce() {
        return this.esniClientNonce;
    }

    public void setEsniClientNonce(byte[] esniClientNonce) {
        this.esniClientNonce = esniClientNonce;
    }

    public byte[] getEsniServerNonce() {
        return this.esniServerNonce;
    }

    public void setEsniServerNonce(byte[] esniServerNonce) {
        this.esniServerNonce = esniServerNonce;
    }

    public byte[] getEsniRecordBytes() {
        return this.esniRecordBytes;
    }

    public void setEsniRecordBytes(byte[] esniRecordBytes) {
        this.esniRecordBytes = esniRecordBytes;
    }

    public EsniDnsKeyRecordVersion getEsniRecordVersion() {
        return this.esniRecordVersion;
    }

    public void setEsniRecordVersion(EsniDnsKeyRecordVersion esniRecordVersion) {
        this.esniRecordVersion = esniRecordVersion;
    }

    public byte[] getEsniRecordChecksum() {
        return this.esniRecordChecksum;
    }

    public void setEsniRecordChecksum(byte[] esniRecordChecksum) {
        this.esniRecordChecksum = esniRecordChecksum;
    }

    public byte[] getPublicName() {
        return this.publicName;
    }

    public void setPublicName(byte[] publicName) {
        this.publicName = publicName;
    }

    public List<KeyShareStoreEntry> getEsniServerKeyShareEntries() {
        return this.esniServerKeyShareEntries;
    }

    public void setEsniServerKeyShareEntries(List<KeyShareStoreEntry> esniServerKeyShareEntries) {
        this.esniServerKeyShareEntries = esniServerKeyShareEntries;
    }

    public List<CipherSuite> getEsniServerCipherSuites() {
        return this.esniServerCipherSuites;
    }

    public void setEsniServerCipherSuites(List<CipherSuite> esniServerCipherSuites) {
        this.esniServerCipherSuites = esniServerCipherSuites;
    }

    public Integer getEsniPaddedLength() {
        return this.esniPaddedLength;
    }

    public void setEsniPaddedLength(Integer esniPaddedLength) {
        this.esniPaddedLength = esniPaddedLength;
    }

    public Long getEsniKeysNotBefore() {
        return this.esniNotBefore;
    }

    public void setEsniKeysNotBefore(Long esniKeysNotBefore) {
        this.esniNotBefore = esniKeysNotBefore;
    }

    public Long getEsniNotAfter() {
        return this.esniNotAfter;
    }

    public void setEsniKeysNotAfter(Long esniKeysNotAfter) {
        this.esniNotAfter = esniKeysNotAfter;
    }

    public byte[] getLastClientHello() {
        return this.lastClientHello;
    }

    public void setLastClientHello(byte[] lastClientHello) {
        this.lastClientHello = lastClientHello;
    }

    public byte[] getExtensionCookie() {
        return this.extensionCookie;
    }

    public void setExtensionCookie(byte[] extensionCookie) {
        this.extensionCookie = extensionCookie;
    }

    public boolean isReceivedMessageWithWrongTls13KeyType() {
        return this.receivedMessageWithWrongTls13KeyType;
    }

    public void setReceivedMessageWithWrongTls13KeyType(boolean receivedMessageWithWrongTls13KeyType) {
        this.receivedMessageWithWrongTls13KeyType = receivedMessageWithWrongTls13KeyType;
    }

    public Integer getOutboundRecordSizeLimit() {
        return this.outboundRecordSizeLimit;
    }

    public void setOutboundRecordSizeLimit(Integer recordSizeLimit) {
        this.outboundRecordSizeLimit = recordSizeLimit;
    }

    public boolean isRecordSizeLimitExtensionActive() {
        return this.outboundRecordSizeLimit != null || this.getConfig().isAddRecordSizeLimitExtension() != false;
    }

    public Boolean isRecordEncryptionActive() {
        if (this.getRecordLayer() == null || this.getRecordLayer().getEncryptorCipher() == null) {
            return false;
        }
        return !(this.getRecordLayer().getEncryptorCipher() instanceof RecordNullCipher);
    }

    public Boolean isRecordDecryptionActive() {
        if (this.getRecordLayer() == null || this.getRecordLayer().getDecryptorCipher() == null) {
            return false;
        }
        return !(this.getRecordLayer().getDecryptorCipher() instanceof RecordNullCipher);
    }

    public Integer getInboundRecordSizeLimit() {
        return this.inboundRecordSizeLimit;
    }

    public int getWriteEpoch() {
        return this.getRecordLayer().getWriteEpoch();
    }

    public int getReadEpoch() {
        return this.getRecordLayer().getReadEpoch();
    }

    public void setWriteEpoch(int epoch) {
        this.getRecordLayer().setWriteEpoch(epoch);
    }

    public void setReadEpoch(int epoch) {
        this.getRecordLayer().setReadEpoch(epoch);
    }

    public long getWriteSequenceNumber(int epoch) {
        return this.getRecordLayer().getEncryptor().getRecordCipher(epoch).getState().getWriteSequenceNumber();
    }

    public long getReadSequenceNumber(int epoch) {
        return this.getRecordLayer().getDecryptor().getRecordCipher(epoch).getState().getReadSequenceNumber();
    }

    public void setWriteSequenceNumber(int epoch, long sqn) {
        this.getRecordLayer().getEncryptor().getRecordCipher(epoch).getState().setWriteSequenceNumber(sqn);
    }

    public void setReadSequenceNumber(int epoch, long sqn) {
        this.getRecordLayer().getDecryptor().getRecordCipher(epoch).getState().setReadSequenceNumber(sqn);
    }

    public byte[] getWriteConnectionId() {
        if (this.writeConnectionIdIndex < this.writeConnectionIds.size()) {
            return this.writeConnectionIds.get(this.writeConnectionIdIndex);
        }
        return null;
    }

    public void setWriteConnectionId(byte[] writeConnectionId) {
        this.writeConnectionIds.set(this.writeConnectionIdIndex, writeConnectionId);
    }

    public void setWriteConnectionId(byte[] writeConnectionId, int index) {
        this.writeConnectionIds.set(index, writeConnectionId);
    }

    public byte[] getReadConnectionId() {
        if (this.readConnectionIdIndex < this.readConnectionIDs.size()) {
            return this.readConnectionIDs.get(this.readConnectionIdIndex);
        }
        return null;
    }

    public void setReadConnectionId(byte[] readConnectionID) {
        this.readConnectionIDs.set(this.readConnectionIdIndex, readConnectionID);
    }

    public void setReadConnectionId(byte[] readConnectionID, int index) {
        this.readConnectionIDs.set(index, readConnectionID);
    }

    public void addNewWriteConnectionId(byte[] writeConnectionId, boolean spare) {
        this.writeConnectionIds.add(writeConnectionId);
        if (!spare) {
            Integer n = this.writeConnectionIdIndex;
            this.writeConnectionIdIndex = this.writeConnectionIdIndex + 1;
            this.getRecordLayer().getEncryptorCipher().getState().setConnectionId(writeConnectionId);
        }
    }

    public void addNewReadConnectionId(byte[] readConnectionId, boolean spare) {
        this.readConnectionIDs.add(readConnectionId);
        if (!spare) {
            Integer n = this.readConnectionIdIndex;
            this.readConnectionIdIndex = this.readConnectionIdIndex + 1;
            this.getRecordLayer().getDecryptorCipher().getState().setConnectionId(readConnectionId);
        }
    }

    public Integer getNumberOfRequestedConnectionIds() {
        return this.numberOfRequestedConnectionIds;
    }

    public void setNumberOfRequestedConnectionIds(Integer numberOfRequestedConnectionIds) {
        this.numberOfRequestedConnectionIds = numberOfRequestedConnectionIds;
    }

    public List<RecordNumber> getDtls13AcknowledgedRecords() {
        return this.dtls13AcknowledgedRecords;
    }

    public void setDtls13AcknowledgedRecords(List<RecordNumber> dtlsAcknowledgedRecords) {
        this.dtls13AcknowledgedRecords = dtlsAcknowledgedRecords;
    }

    public List<RecordNumber> getDtls13ReceivedAcknowledgedRecords() {
        return this.dtls13ReceivedAcknowledgedRecords;
    }

    public void setDtls13ReceivedAcknowledgedRecords(List<RecordNumber> dtlsReceivedAcknowledgedRecords) {
        this.dtls13ReceivedAcknowledgedRecords = dtlsReceivedAcknowledgedRecords;
    }

    public BigInteger getServerEphemeralDhGenerator() {
        return this.serverEphemeralDhGenerator;
    }

    public void setServerEphemeralDhGenerator(BigInteger serverEphemeralDhGenerator) {
        this.serverEphemeralDhGenerator = serverEphemeralDhGenerator;
    }

    public BigInteger getServerEphemeralDhModulus() {
        return this.serverEphemeralDhModulus;
    }

    public void setServerEphemeralDhModulus(BigInteger serverEphemeralDhModulus) {
        this.serverEphemeralDhModulus = serverEphemeralDhModulus;
    }

    public BigInteger getServerEphemeralDhPrivateKey() {
        return this.serverEphemeralDhPrivateKey;
    }

    public void setServerEphemeralDhPrivateKey(BigInteger serverEphemeralDhPrivateKey) {
        this.serverEphemeralDhPrivateKey = serverEphemeralDhPrivateKey;
    }

    public BigInteger getServerEphemeralDhPublicKey() {
        return this.serverEphemeralDhPublicKey;
    }

    public void setServerEphemeralDhPublicKey(BigInteger serverEphemeralDhPublicKey) {
        this.serverEphemeralDhPublicKey = serverEphemeralDhPublicKey;
    }

    public BigInteger getClientEphemeralDhPrivateKey() {
        return this.clientEphemeralDhPrivateKey;
    }

    public void setClientEphemeralDhPrivateKey(BigInteger clientEphemeralDhPrivateKey) {
        this.clientEphemeralDhPrivateKey = clientEphemeralDhPrivateKey;
    }

    public BigInteger getClientEphemeralDhPublicKey() {
        return this.clientEphemeralDhPublicKey;
    }

    public void setClientEphemeralDhPublicKey(BigInteger clientEphemeralDhPublicKey) {
        this.clientEphemeralDhPublicKey = clientEphemeralDhPublicKey;
    }

    public Point getClientEphemeralEcPublicKey() {
        return this.clientEphemeralEcPublicKey;
    }

    public void setClientEphemeralEcPublicKey(Point clientEphemeralEcPublicKey) {
        this.clientEphemeralEcPublicKey = clientEphemeralEcPublicKey;
    }

    public Point getServerEphemeralEcPublicKey() {
        return this.serverEphemeralEcPublicKey;
    }

    public void setServerEphemeralEcPublicKey(Point serverEphemeralEcPublicKey) {
        this.serverEphemeralEcPublicKey = serverEphemeralEcPublicKey;
    }

    public BigInteger getServerEphemeralEcPrivateKey() {
        return this.serverEphemeralEcPrivateKey;
    }

    public void setServerEphemeralEcPrivateKey(BigInteger serverEphemeralEcPrivateKey) {
        this.serverEphemeralEcPrivateKey = serverEphemeralEcPrivateKey;
    }

    public BigInteger getClientEphemeralEcPrivateKey() {
        return this.clientEphemeralEcPrivateKey;
    }

    public void setClientEphemeralEcPrivateKey(BigInteger clientEphemeralEcPrivateKey) {
        this.clientEphemeralEcPrivateKey = clientEphemeralEcPrivateKey;
    }

    public BigInteger getServerEphemeralRsaExportModulus() {
        return this.serverEphemeralRsaExportModulus;
    }

    public void setServerEphemeralRsaExportModulus(BigInteger serverEphemeralRsaExportModulus) {
        this.serverEphemeralRsaExportModulus = serverEphemeralRsaExportModulus;
    }

    public BigInteger getServerEphemeralRsaExportPublicKey() {
        return this.serverEphemeralRsaExportPublicKey;
    }

    public void setServerEphemeralRsaExportPublicKey(BigInteger serverEphemeralRsaExportPublicKey) {
        this.serverEphemeralRsaExportPublicKey = serverEphemeralRsaExportPublicKey;
    }

    public BigInteger getServerEphemeralRsaExportPrivateKey() {
        return this.serverEphemeralRsaExportPrivateKey;
    }

    public void setServerEphemeralRsaExportPrivateKey(BigInteger serverEphemeralRsaExportPrivateKey) {
        this.serverEphemeralRsaExportPrivateKey = serverEphemeralRsaExportPrivateKey;
    }

    public Integer getPeerReceiveLimit() {
        return this.peerReceiveLimit;
    }

    public void setPeerReceiveLimit(Integer peerReceiveLimit) {
        this.peerReceiveLimit = peerReceiveLimit;
    }
}

