/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer.impl;

import de.rub.nds.protocol.exception.EndOfStreamException;
import de.rub.nds.protocol.exception.TimeoutException;
import de.rub.nds.tlsattacker.core.http.HttpMessage;
import de.rub.nds.tlsattacker.core.http.HttpMessageHandler;
import de.rub.nds.tlsattacker.core.http.HttpRequestMessage;
import de.rub.nds.tlsattacker.core.http.HttpResponseMessage;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerProcessingResult;
import de.rub.nds.tlsattacker.core.layer.ProtocolLayer;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.data.Handler;
import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.layer.hints.HttpLayerHint;
import de.rub.nds.tlsattacker.core.layer.hints.LayerProcessingHint;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpLayer
extends ProtocolLayer<Context, HttpLayerHint, HttpMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Context context;

    public HttpLayer(Context context) {
        super(ImplementedLayers.HTTP);
        this.context = context;
    }

    @Override
    public LayerProcessingResult<HttpMessage> sendConfiguration() throws IOException {
        LayerConfiguration configuration = this.getLayerConfiguration();
        if (configuration != null && configuration.getContainerList() != null) {
            for (HttpMessage httpMsg : this.getUnprocessedConfiguredContainers()) {
                if (!this.prepareDataContainer(httpMsg, this.context)) continue;
                Handler handler = httpMsg.getHandler(this.context);
                ((HttpMessageHandler)handler).adjustContext(httpMsg);
                Serializer serializer = httpMsg.getSerializer(this.context);
                byte[] serializedMessage = serializer.serialize();
                this.getLowerLayer().sendData(null, serializedMessage);
                this.addProducedContainer(httpMsg);
            }
        }
        return this.getLayerResult();
    }

    @Override
    public LayerProcessingResult<HttpMessage> sendData(LayerProcessingHint hint, byte[] additionalData) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void receiveMoreDataForHint(LayerProcessingHint hint) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public LayerProcessingResult<HttpMessage> receiveData() {
        try {
            do {
                if (this.context.getConnection().getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
                    HttpResponseMessage httpResponse = new HttpResponseMessage();
                    this.readDataContainer(httpResponse, this.context);
                    continue;
                }
                HttpRequestMessage httpRequest = new HttpRequestMessage();
                this.readDataContainer(httpRequest, this.context);
            } while (this.shouldContinueProcessing());
        }
        catch (TimeoutException ex) {
            LOGGER.debug((Object)ex);
        }
        catch (EndOfStreamException ex) {
            if (this.getLayerConfiguration() != null && this.getLayerConfiguration().getContainerList() != null && !this.getLayerConfiguration().getContainerList().isEmpty()) {
                LOGGER.debug("Reached end of stream, cannot parse more messages", (Throwable)ex);
            }
            LOGGER.debug("No messages required for layer.");
        }
        return this.getLayerResult();
    }

    @Override
    public boolean shouldContinueProcessing() {
        return super.shouldContinueProcessing() && this.getUnreadBytes() == null;
    }
}

