/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer.impl;

import de.rub.nds.protocol.exception.EndOfStreamException;
import de.rub.nds.protocol.exception.TimeoutException;
import de.rub.nds.tlsattacker.core.constants.SSL2MessageType;
import de.rub.nds.tlsattacker.core.constants.SSL2TotalHeaderLengths;
import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerProcessingResult;
import de.rub.nds.tlsattacker.core.layer.ProtocolLayer;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.data.Handler;
import de.rub.nds.tlsattacker.core.layer.data.Preparator;
import de.rub.nds.tlsattacker.core.layer.data.Serializer;
import de.rub.nds.tlsattacker.core.layer.hints.LayerProcessingHint;
import de.rub.nds.tlsattacker.core.layer.hints.RecordLayerHint;
import de.rub.nds.tlsattacker.core.layer.stream.HintedInputStream;
import de.rub.nds.tlsattacker.core.protocol.handler.SSL2MessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientMasterKeyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2Message;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerVerifyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.UnknownSSL2Message;
import de.rub.nds.tlsattacker.core.protocol.preparator.SSL2MessagePreparator;
import de.rub.nds.tlsattacker.core.state.Context;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2Layer
extends ProtocolLayer<Context, LayerProcessingHint, SSL2Message> {
    private static final Logger LOGGER = LogManager.getLogger();
    private Context context;

    public SSL2Layer(Context context) {
        super(ImplementedLayers.SSL2);
        this.context = context;
    }

    @Override
    public LayerProcessingResult<SSL2Message> sendConfiguration() throws IOException {
        LayerConfiguration configuration = this.getLayerConfiguration();
        if (configuration != null && configuration.getContainerList() != null && !configuration.getContainerList().isEmpty()) {
            for (SSL2Message ssl2message : this.getUnprocessedConfiguredContainers()) {
                Preparator preparator = ssl2message.getPreparator(this.context);
                ((SSL2MessagePreparator)preparator).prepare();
                preparator.afterPrepare();
                Handler handler = ssl2message.getHandler(this.context);
                handler.adjustContext(ssl2message);
                Serializer serializer = ssl2message.getSerializer(this.context);
                byte[] serializedMessage = serializer.serialize();
                ssl2message.setCompleteResultingMessage(serializedMessage);
                ((SSL2MessageHandler)handler).adjustContextAfterSerialize(ssl2message);
                ((SSL2MessageHandler)handler).updateDigest(ssl2message, true);
                this.getLowerLayer().sendData(new RecordLayerHint(ssl2message.getProtocolMessageType()), serializedMessage);
                this.addProducedContainer(ssl2message);
            }
        }
        return this.getLayerResult();
    }

    @Override
    public LayerProcessingResult<SSL2Message> sendData(LayerProcessingHint hint, byte[] additionalData) throws IOException {
        return this.sendConfiguration();
    }

    @Override
    public LayerProcessingResult<SSL2Message> receiveData() {
        try {
            int messageLength = 0;
            byte paddingLength = 0;
            HintedInputStream dataStream = null;
            SSL2MessageType messageType = SSL2MessageType.SSL_UNKNOWN;
            try {
                dataStream = this.getLowerLayer().getDataStream();
                if (dataStream.available() == 0) {
                    LOGGER.debug("Reached end of stream, cannot parse more messages");
                    return this.getLayerResult();
                }
                byte[] totalHeader = dataStream.readNBytes(2);
                if (SSL2TotalHeaderLengths.isNoPaddingHeader(totalHeader[0])) {
                    messageLength = SSL2Layer.resolveUnpaddedMessageLength(totalHeader);
                    paddingLength = 0;
                } else {
                    if (SSL2TotalHeaderLengths.isNoPaddingHeader(totalHeader[0])) {
                        messageLength = SSL2Layer.resolveUnpaddedMessageLength(totalHeader);
                        paddingLength = 0;
                    } else {
                        messageLength = SSL2Layer.resolvePaddedMessageLength(totalHeader);
                        paddingLength = dataStream.readByte();
                    }
                    messageType = SSL2MessageType.getMessageType(dataStream.readByte());
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to parse SSL2 message header, parsing as unknown SSL2 message", (Throwable)e);
                messageType = SSL2MessageType.SSL_UNKNOWN;
            }
            SSL2Message message = null;
            switch (messageType) {
                case SSL_CLIENT_HELLO: {
                    message = new SSL2ClientHelloMessage();
                    break;
                }
                case SSL_CLIENT_MASTER_KEY: {
                    message = new SSL2ClientMasterKeyMessage();
                    break;
                }
                case SSL_SERVER_VERIFY: {
                    message = new SSL2ServerVerifyMessage();
                    break;
                }
                case SSL_SERVER_HELLO: {
                    message = new SSL2ServerHelloMessage();
                    break;
                }
                default: {
                    message = new UnknownSSL2Message();
                }
            }
            message.setType(messageType.getType());
            message.setMessageLength(messageLength);
            message.setPaddingLength(Integer.valueOf(paddingLength));
            this.readDataContainer(message, this.context);
        }
        catch (TimeoutException ex) {
            LOGGER.debug("Received a timeout");
        }
        catch (EndOfStreamException ex) {
            LOGGER.debug("Reached end of stream, cannot parse more messages", (Throwable)ex);
        }
        return this.getLayerResult();
    }

    private static int resolvePaddedMessageLength(byte[] totalHeaderLength) {
        return (totalHeaderLength[0] & SSL2TotalHeaderLengths.ALL_BUT_TWO_BIT.getValue()) << 8 | totalHeaderLength[1] & 0xFF;
    }

    private static int resolveUnpaddedMessageLength(byte[] totalHeaderLength) {
        return (totalHeaderLength[0] & SSL2TotalHeaderLengths.ALL_BUT_ONE_BIT.getValue()) << 8 | totalHeaderLength[1] & 0xFF;
    }

    @Override
    public void receiveMoreDataForHint(LayerProcessingHint hint) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

