/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer.impl;

import de.rub.nds.tlsattacker.core.layer.LayerConfiguration;
import de.rub.nds.tlsattacker.core.layer.LayerProcessingResult;
import de.rub.nds.tlsattacker.core.layer.ProtocolLayer;
import de.rub.nds.tlsattacker.core.layer.constant.ImplementedLayers;
import de.rub.nds.tlsattacker.core.layer.hints.LayerProcessingHint;
import de.rub.nds.tlsattacker.core.layer.stream.HintedLayerInputStream;
import de.rub.nds.tlsattacker.core.state.Context;
import de.rub.nds.tlsattacker.core.tcp.TcpStreamContainer;
import de.rub.nds.tlsattacker.transport.tcp.TcpTransportHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class TcpLayer
extends ProtocolLayer<Context, LayerProcessingHint, TcpStreamContainer> {
    private final Context context;

    public TcpLayer(Context context) {
        super(ImplementedLayers.TCP);
        this.context = context;
    }

    @Override
    public LayerProcessingResult<TcpStreamContainer> sendConfiguration() throws IOException {
        LayerConfiguration configuration = this.getLayerConfiguration();
        if (configuration != null) {
            for (TcpStreamContainer container : this.getUnprocessedConfiguredContainers()) {
                this.prepareDataContainer(container, this.context);
                this.addProducedContainer(container);
                TcpTransportHandler handler = this.getTransportHandler();
                handler.sendData(container.getSerializer(this.context).serialize());
            }
        }
        return this.getLayerResult();
    }

    @Override
    public LayerProcessingResult<TcpStreamContainer> sendData(LayerProcessingHint hint, byte[] data) throws IOException {
        TcpStreamContainer container = this.getUnprocessedConfiguredContainers().isEmpty() ? new TcpStreamContainer() : (TcpStreamContainer)this.getUnprocessedConfiguredContainers().get(0);
        container.setConfigData(data);
        this.prepareDataContainer(container, this.context);
        this.addProducedContainer(container);
        TcpTransportHandler handler = this.getTransportHandler();
        handler.sendData(container.getSerializer(this.context).serialize());
        return this.getLayerResult();
    }

    @Override
    public void receiveMoreDataForHint(LayerProcessingHint hint) throws IOException {
        byte[] receivedTcpData = this.getTransportHandler().fetchData();
        TcpStreamContainer tcpStreamContainer = new TcpStreamContainer();
        tcpStreamContainer.getParser(this.context, new ByteArrayInputStream(receivedTcpData)).parse(tcpStreamContainer);
        tcpStreamContainer.getPreparator(this.context).prepareAfterParse();
        tcpStreamContainer.getHandler(this.context).adjustContext(tcpStreamContainer);
        this.addProducedContainer(tcpStreamContainer);
        if (this.currentInputStream == null) {
            this.currentInputStream = new HintedLayerInputStream(null, this);
            this.currentInputStream.extendStream(receivedTcpData);
        } else {
            this.currentInputStream.extendStream(receivedTcpData);
        }
    }

    @Override
    public LayerProcessingResult<TcpStreamContainer> receiveData() {
        return new LayerProcessingResult<TcpStreamContainer>(null, this.getLayerType(), true);
    }

    private TcpTransportHandler getTransportHandler() {
        if (this.context.getTransportHandler() == null) {
            throw new RuntimeException("TransportHandler is not set in context!");
        }
        if (!(this.context.getTransportHandler() instanceof TcpTransportHandler)) {
            throw new RuntimeException("Trying to set TCP layer with non TCP TransportHandler");
        }
        return (TcpTransportHandler)this.context.getTransportHandler();
    }
}

