/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.layer.stream;

import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import de.rub.nds.tlsattacker.core.layer.ProtocolLayer;
import de.rub.nds.tlsattacker.core.layer.hints.LayerProcessingHint;
import de.rub.nds.tlsattacker.core.layer.stream.HintedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HintedLayerInputStream
extends HintedInputStream {
    private final ProtocolLayer<?, ?, ?> layer;
    private ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);

    public HintedLayerInputStream(LayerProcessingHint hint, ProtocolLayer<?, ?, ?> layer) {
        super(hint);
        this.layer = layer;
    }

    @Override
    public int read() throws IOException {
        if (this.stream.available() > 0) {
            return this.stream.read();
        }
        this.layer.receiveMoreDataForHint(this.getHint());
        return this.stream.read();
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    protected InputStream getDataSource() {
        return this.stream;
    }

    @Override
    public void extendStream(byte[] bytes) {
        try {
            SilentByteArrayOutputStream outStream = new SilentByteArrayOutputStream();
            this.stream.transferTo((OutputStream)outStream);
            outStream.write(bytes);
            this.stream = new ByteArrayInputStream(outStream.toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException("IO Exception from ByteArrayStream");
        }
    }
}

