/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.protocol.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.AckMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ack.RecordNumber;
import de.rub.nds.tlsattacker.core.state.Context;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AckHandler
extends ProtocolMessageHandler<AckMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public AckHandler(Context context) {
        super(context.getTlsContext());
    }

    @Override
    public void adjustContext(AckMessage message) {
        if (this.tlsContext.getChooser().getConnectionEndType() != this.tlsContext.getTalkingConnectionEndType()) {
            if (this.tlsContext.getDtls13ReceivedAcknowledgedRecords() == null) {
                this.tlsContext.setDtls13ReceivedAcknowledgedRecords(new LinkedList<RecordNumber>());
            }
            this.tlsContext.getDtls13ReceivedAcknowledgedRecords().addAll(message.getRecordNumbers());
        }
    }
}

