/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.ClientCertificateType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.SignatureAndHashAlgorithmsExtensionMessage;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertificateRequestHandler
extends HandshakeMessageHandler<CertificateRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public CertificateRequestHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(CertificateRequestMessage message) {
        if (this.tlsContext.getChooser().getSelectedProtocolVersion().is13()) {
            this.adjustCertificateRequestContext(message);
            this.adjustServerSupportedSignatureAndHashAlgorithms(message);
        } else {
            this.adjustClientCertificateTypes(message);
            this.adjustDistinguishedNames(message);
            if (this.tlsContext.getChooser().getSelectedProtocolVersion() == ProtocolVersion.TLS12 || this.tlsContext.getChooser().getSelectedProtocolVersion() == ProtocolVersion.DTLS12) {
                this.adjustServerSupportedSignatureAndHashAlgorithms(message);
            }
        }
    }

    private void adjustServerSupportedSignatureAndHashAlgorithms(CertificateRequestMessage message) {
        SignatureAndHashAlgorithmsExtensionMessage extension;
        List<Object> algoList = this.tlsContext.getChooser().getSelectedProtocolVersion().is13() ? ((extension = message.getExtension(SignatureAndHashAlgorithmsExtensionMessage.class)) != null ? this.convertSignatureAndHashAlgorithms((byte[])extension.getSignatureAndHashAlgorithms().getValue()) : (message.getSignatureHashAlgorithms() != null ? this.convertSignatureAndHashAlgorithms((byte[])message.getSignatureHashAlgorithms().getValue()) : new LinkedList())) : (message.getSignatureHashAlgorithms() != null ? this.convertSignatureAndHashAlgorithms((byte[])message.getSignatureHashAlgorithms().getValue()) : new LinkedList());
        this.tlsContext.setServerSupportedSignatureAndHashAlgorithms(algoList);
        LOGGER.debug("Set ServerSupportedSignatureAndHashAlgorithms to {}", algoList);
    }

    private void adjustDistinguishedNames(CertificateRequestMessage message) {
        if (message.getDistinguishedNames() != null && message.getDistinguishedNames().getValue() != null) {
            byte[] distinguishedNames = (byte[])message.getDistinguishedNames().getValue();
            this.tlsContext.setDistinguishedNames(distinguishedNames);
            LOGGER.debug("Set DistinguishedNames in Context to {}", (Object)distinguishedNames);
        } else {
            LOGGER.debug("Not adjusting DistinguishedNames");
        }
    }

    private void adjustClientCertificateTypes(CertificateRequestMessage message) {
        List<ClientCertificateType> clientCertTypes = this.convertClientCertificateTypes((byte[])message.getClientCertificateTypes().getValue());
        this.tlsContext.setClientCertificateTypes(clientCertTypes);
        LOGGER.debug("Set ClientCertificateType in Context to {} ", clientCertTypes);
    }

    private List<ClientCertificateType> convertClientCertificateTypes(byte[] bytesToConvert) {
        LinkedList<ClientCertificateType> list = new LinkedList<ClientCertificateType>();
        for (byte b : bytesToConvert) {
            ClientCertificateType type = ClientCertificateType.getClientCertificateType(b);
            if (type == null) {
                LOGGER.warn("Cannot convert: {} to a ClientCertificateType", (Object)b);
                continue;
            }
            list.add(type);
        }
        return list;
    }

    private List<SignatureAndHashAlgorithm> convertSignatureAndHashAlgorithms(byte[] bytesToConvert) {
        if (bytesToConvert.length % 2 != 0) {
            LOGGER.warn("Cannot convert: {} to a List<SignatureAndHashAlgorithm>", (Object)bytesToConvert);
            return new LinkedList<SignatureAndHashAlgorithm>();
        }
        LinkedList<SignatureAndHashAlgorithm> list = new LinkedList<SignatureAndHashAlgorithm>();
        for (int i = 0; i < bytesToConvert.length; i += 2) {
            byte[] copied = new byte[]{bytesToConvert[i], bytesToConvert[i + 1]};
            SignatureAndHashAlgorithm algo = SignatureAndHashAlgorithm.getSignatureAndHashAlgorithm(copied);
            if (algo != null) {
                list.add(algo);
                continue;
            }
            LOGGER.warn("Cannot convert: {} to a SignatureAndHashAlgorithm", (Object)copied);
        }
        return list;
    }

    private void adjustCertificateRequestContext(CertificateRequestMessage msg) {
        this.tlsContext.setCertificateRequestContext((byte[])msg.getCertificateRequestContext().getValue());
    }
}

