/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.layer.context.TlsContext;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateVerifyMessage;

public class CertificateVerifyHandler
extends HandshakeMessageHandler<CertificateVerifyMessage> {
    public CertificateVerifyHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public void adjustContext(CertificateVerifyMessage message) {
        byte[] signatureAndHashAlgorithmBytes = (byte[])message.getSignatureHashAlgorithm().getValue();
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureAndHashAlgorithm.getSignatureAndHashAlgorithm(signatureAndHashAlgorithmBytes);
        this.tlsContext.setSelectedSignatureAndHashAlgorithm(signatureAndHashAlgorithm);
    }
}

